/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeetLevel
implements Comparable<LeetLevel> {
    public static final LeetLevel LEVEL1 = new LeetLevel(1);
    public static final LeetLevel LEVEL2 = new LeetLevel(2);
    public static final LeetLevel LEVEL3 = new LeetLevel(3);
    public static final LeetLevel LEVEL4 = new LeetLevel(4);
    public static final LeetLevel LEVEL5 = new LeetLevel(5);
    public static final LeetLevel LEVEL6 = new LeetLevel(6);
    public static final LeetLevel LEVEL7 = new LeetLevel(7);
    public static final LeetLevel LEVEL8 = new LeetLevel(8);
    public static final LeetLevel LEVEL9 = new LeetLevel(9);
    public static final LeetLevel[] LEVELS = new LeetLevel[]{LEVEL1, LEVEL2, LEVEL3, LEVEL4, LEVEL5, LEVEL6, LEVEL7, LEVEL8, LEVEL9};
    private int level = 1;

    private LeetLevel() {
    }

    private LeetLevel(int l) {
        this.level = l;
    }

    public static LeetLevel[] getLevels() {
        return LEVELS;
    }

    public static LeetLevel fromInt(int i) {
        if (i >= LEVEL1.getLevel() && i <= LEVEL9.getLevel()) {
            return LEVELS[i - 1];
        }
        return LEVELS[0];
    }

    public static LeetLevel fromString(String str) throws Exception {
        if (str.length() == 0) {
            return LEVEL1;
        }
        try {
            int i = Integer.parseInt(str);
            if (i >= 1 && i <= LEVELS.length) {
                return LEVELS[i - 1];
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String exceptionStr = String.format("Invalid LeetLevel '%1s', valid values are '1' to '9'", str);
        throw new Exception(exceptionStr);
    }

    public String toString() {
        return Integer.toString(this.level);
    }

    public int getLevel() {
        return this.level;
    }

    public int getOrdinal() {
        return this.getLevel() - 1;
    }

    @Override
    public int compareTo(LeetLevel o) {
        if (this.level < o.level) {
            return -1;
        }
        if (this.level > o.level) {
            return 1;
        }
        return 0;
    }
}

