/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.daveware.passwordmaker.Account;
import org.daveware.passwordmaker.AlgorithmType;
import org.daveware.passwordmaker.LeetEncoder;
import org.daveware.passwordmaker.LeetLevel;
import org.daveware.passwordmaker.LeetType;
import org.daveware.passwordmaker.ParsedDomain;
import org.daveware.passwordmaker.SecureByteArray;
import org.daveware.passwordmaker.SecureCharArray;

public class PasswordMaker {
    private static Pattern urlRegex = Pattern.compile("([^:\\/\\/]*:\\/\\/)?([^:\\/]*)([^#]*).*");
    private static String CRYPTO_PROVIDER = "BC";
    private Account verificationAccount = PasswordMaker.createVerificationAccount();

    private static Account createVerificationAccount() {
        Account account = new Account();
        account.setCharacterSet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        account.setAlgorithm(AlgorithmType.SHA256);
        account.setLength(3);
        account.setModifier("");
        account.setPrefix("");
        account.setSuffix("");
        account.setLeetType(LeetType.NONE);
        return account;
    }

    public static void setDefaultCryptoProvider(String provider) {
        CRYPTO_PROVIDER = provider;
    }

    public static String getDefaultCryptoProvider() {
        return CRYPTO_PROVIDER;
    }

    public static double calcPasswordStrength(SecureCharArray pw) {
        double r1;
        int i;
        ArrayList<Character> uniques = new ArrayList<Character>();
        int pwLength = pw.size();
        if (pwLength <= 2) {
            return 0.0;
        }
        for (i = 0; i < pwLength; ++i) {
            int j;
            for (j = 0; j < uniques.size() && (i == j || pw.getCharAt(i) != ((Character)uniques.get(j)).charValue()); ++j) {
            }
            if (j != uniques.size()) continue;
            uniques.add(Character.valueOf(pw.getCharAt(i)));
        }
        double r0 = (double)uniques.size() / (double)pwLength;
        if (uniques.size() == 1) {
            r0 = 0.0;
        }
        r1 = (r1 = (double)pwLength) >= 15.0 ? 10.0 : (r1 < 5.0 ? -5.0 : (r1 -= 5.0));
        double quarterLen = Math.round((double)pwLength / 4.0);
        double num = 0.0;
        for (i = 0; i < pwLength; ++i) {
            if (Character.isDigit(pw.getCharAt(i))) continue;
            num += 1.0;
        }
        double c = (num = (double)pwLength - num) > quarterLen * 2.0 ? quarterLen : Math.abs(quarterLen - num);
        double r2 = 1.0 - c / quarterLen;
        num = 0.0;
        for (i = 0; i < pwLength; ++i) {
            if (!Character.isLetterOrDigit(pw.getCharAt(i)) && pw.getCharAt(i) != '_') continue;
            num += 1.0;
        }
        c = (num = (double)pwLength - num) > quarterLen * 2.0 ? quarterLen : Math.abs(quarterLen - num);
        double r3 = 1.0 - c / quarterLen;
        num = 0.0;
        for (i = 0; i < pwLength; ++i) {
            if (Character.isUpperCase(pw.getCharAt(i))) continue;
            num += 1.0;
        }
        c = (num = (double)pwLength - num) > quarterLen * 2.0 ? quarterLen : Math.abs(quarterLen - num);
        double r4 = 1.0 - c / quarterLen;
        num = 0.0;
        for (i = 0; i < pwLength; ++i) {
            if (Character.isLowerCase(pw.getCharAt(i))) continue;
            num += 1.0;
        }
        c = (num = (double)pwLength - num) > quarterLen * 2.0 ? quarterLen : Math.abs(quarterLen - num);
        double r5 = 1.0 - c / quarterLen;
        double pwStrength = (r0 + r2 + r3 + r4 + r5) / 5.0 * 100.0 + r1;
        if (pwStrength < 0.0) {
            pwStrength = 0.0;
        }
        if (pwStrength > 100.0) {
            pwStrength = 100.0;
        }
        return pwStrength;
    }

    public SecureCharArray rstr2any(char[] input, String encoding, boolean trim) throws Exception {
        int q;
        int[] quotient;
        int x;
        int qCounter;
        int quotient_length;
        int i;
        int length = input.length;
        int remainders_count = 0;
        int outputPosition = 0;
        SecureCharArray output = new SecureCharArray();
        if (length % 2 != 0) {
            return output;
        }
        int divisor = encoding.length();
        int dividend_length = (int)Math.ceil((double)length / 2.0);
        int[] dividend = new int[dividend_length];
        for (i = 0; i < dividend_length; ++i) {
            dividend[i] = input[i * 2] << 8 | input[i * 2 + 1];
        }
        int full_length = (int)Math.ceil((double)length * 8.0 / (Math.log(encoding.length()) / Math.log(2.0)));
        int[] remainders = new int[full_length];
        if (trim) {
            while (dividend_length > 0) {
                quotient_length = 0;
                qCounter = 0;
                x = 0;
                quotient = new int[dividend_length];
                for (i = 0; i < dividend_length; ++i) {
                    x = (x << 16) + dividend[i];
                    q = (int)Math.floor((double)x / (double)divisor);
                    x -= q * divisor;
                    if (quotient_length <= 0 && q <= 0) continue;
                    quotient[qCounter++] = q;
                    ++quotient_length;
                }
                remainders[remainders_count++] = x;
                dividend_length = quotient_length;
                dividend = quotient;
            }
            full_length = remainders_count;
        } else {
            for (int j = 0; j < full_length; ++j) {
                quotient_length = 0;
                qCounter = 0;
                x = 0;
                quotient = new int[dividend_length];
                for (i = 0; i < dividend_length; ++i) {
                    x = (x << 16) + dividend[i];
                    q = (int)Math.floor((double)x / (double)divisor);
                    x -= q * divisor;
                    if (quotient_length <= 0 && q <= 0) continue;
                    quotient[qCounter++] = q;
                    ++quotient_length;
                }
                remainders[j] = x;
                dividend_length = quotient_length;
                dividend = quotient;
            }
        }
        if (output.size() < full_length) {
            output.resize(full_length, false);
        }
        for (i = full_length - 1; i >= 0; --i) {
            output.setCharAt(outputPosition++, encoding.charAt(remainders[i]));
        }
        return output;
    }

    public final String getModifiedInputText(String inputText, Account account) {
        boolean hasSubDomain;
        Set<Account.UrlComponents> uriComponents = account.getUrlComponents();
        if (uriComponents.isEmpty()) {
            if (account.isDefault()) {
                return "";
            }
            return account.getUrl();
        }
        Matcher matcher = urlRegex.matcher(inputText);
        if (!matcher.matches()) {
            return inputText;
        }
        String protocol = matcher.group(1);
        String domainText = matcher.group(2);
        String portPath = matcher.group(3);
        if (protocol == null) {
            protocol = "";
        }
        if (domainText == null) {
            domainText = "";
        }
        if (portPath == null) {
            portPath = "";
        }
        StringBuilder retVal = new StringBuilder(inputText.length());
        if (uriComponents.contains((Object)Account.UrlComponents.Protocol) && protocol.length() > 0) {
            retVal.append(protocol);
        }
        ParsedDomain domain = new ParsedDomain(domainText);
        boolean bl = hasSubDomain = uriComponents.contains((Object)Account.UrlComponents.Subdomain) && domain.hasSubDomains();
        if (hasSubDomain) {
            retVal.append(domain.getSubdomains());
        }
        if (uriComponents.contains((Object)Account.UrlComponents.Domain) && domain.hasDomain()) {
            if (hasSubDomain) {
                retVal.append(".");
            }
            retVal.append(domain.getDomain());
        }
        if (uriComponents.contains((Object)Account.UrlComponents.PortPathAnchorQuery) && portPath.length() > 0) {
            retVal.append(portPath);
        }
        return retVal.toString();
    }

    public SecureCharArray makePassword(SecureCharArray masterPassword, Account account, String inputText) throws Exception {
        if (account.isHmac() && masterPassword.length() == 0) {
            return new SecureCharArray();
        }
        LeetLevel leetLevel = account.getLeetLevel();
        int length = account.getLength();
        SecureCharArray output = null;
        SecureCharArray data = null;
        try {
            if (account.getCharacterSet().length() < 2) {
                throw new Exception("Account contains a character set that is too short");
            }
            data = new SecureCharArray(this.getModifiedInputText(inputText, account) + account.getUsername() + account.getModifier());
            if (account.getLeetType() == LeetType.BEFORE || account.getLeetType() == LeetType.BOTH) {
                LeetEncoder.leetConvert(leetLevel, masterPassword);
                LeetEncoder.leetConvert(leetLevel, data);
            }
            output = this.hashTheData(masterPassword, data, account);
            if (account.getLeetType() == LeetType.AFTER || account.getLeetType() == LeetType.BOTH) {
                LeetEncoder.leetConvert(leetLevel, output);
            }
            if (account.getPrefix().length() > 0) {
                SecureCharArray prefix = new SecureCharArray(account.getPrefix());
                output.prepend(prefix);
                prefix.erase();
            }
            output.resize(length, true);
            if (account.getSuffix().length() > 0) {
                SecureCharArray suffix = new SecureCharArray(account.getSuffix());
                if (length < suffix.size()) {
                    output.replace(suffix);
                    output.resize(length, true);
                } else {
                    output.resize(length - suffix.size(), true);
                    output.append(suffix);
                }
                suffix.erase();
            }
        }
        catch (Exception e) {
            if (output != null) {
                output.erase();
            }
            throw e;
        }
        finally {
            if (data != null) {
                data.erase();
            }
        }
        return output;
    }

    public SecureCharArray makePassword(SecureCharArray masterPassword, Account account) throws Exception {
        return this.makePassword(masterPassword, account, account.getUrl());
    }

    public SecureCharArray generateVerificationCode(SecureCharArray masterPassword) throws Exception {
        return this.makePassword(masterPassword, this.verificationAccount, "");
    }

    private SecureCharArray hashTheData(SecureCharArray masterPassword, SecureCharArray data, Account account) throws Exception {
        SecureCharArray output = new SecureCharArray();
        SecureCharArray secureIteration = new SecureCharArray();
        SecureCharArray intermediateOutput = null;
        int count = 0;
        int length = account.getLength();
        try {
            while (output.size() < length) {
                if (count == 0) {
                    intermediateOutput = this.runAlgorithm(masterPassword, data, account);
                } else {
                    secureIteration.replace(masterPassword);
                    secureIteration.append(new SecureCharArray("\n"));
                    secureIteration.append(new SecureCharArray(Integer.toString(count)));
                    intermediateOutput = this.runAlgorithm(secureIteration, data, account);
                    secureIteration.erase();
                }
                output.append(intermediateOutput);
                intermediateOutput.erase();
                ++count;
            }
        }
        catch (Exception e) {
            output.erase();
            throw e;
        }
        finally {
            if (intermediateOutput != null) {
                intermediateOutput.erase();
            }
            secureIteration.erase();
        }
        return output;
    }

    private SecureCharArray runAlgorithm(SecureCharArray masterPassword, SecureCharArray data, Account account) throws Exception {
        SecureCharArray output = null;
        SecureCharArray digestChars = null;
        SecureByteArray masterPasswordBytes = null;
        SecureByteArray dataBytes = null;
        try {
            masterPasswordBytes = new SecureByteArray(masterPassword.getData());
            dataBytes = new SecureByteArray(data.getData());
            if (!account.isHmac()) {
                dataBytes.prepend(masterPasswordBytes);
            }
            if (account.isHmac()) {
                String algoName = "HMAC" + account.getAlgorithm().getName();
                Mac mac = Mac.getInstance(algoName, CRYPTO_PROVIDER);
                mac.init(new SecretKeySpec(masterPasswordBytes.getData(), algoName));
                mac.reset();
                mac.update(dataBytes.getData());
                digestChars = new SecureCharArray(mac.doFinal());
            } else {
                MessageDigest md = MessageDigest.getInstance(account.getAlgorithm().getName(), CRYPTO_PROVIDER);
                digestChars = new SecureCharArray(md.digest(dataBytes.getData()));
            }
            output = this.rstr2any(digestChars.getData(), account.getCharacterSet(), account.isTrim());
        }
        catch (Exception e) {
            if (output != null) {
                output.erase();
            }
            throw e;
        }
        finally {
            if (masterPasswordBytes != null) {
                masterPasswordBytes.erase();
            }
            if (dataBytes != null) {
                dataBytes.erase();
            }
            if (digestChars != null) {
                digestChars.erase();
            }
        }
        return output;
    }
}

