/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

public class SecureByteArray {
    private byte[] data = null;

    public SecureByteArray() {
        this.data = new byte[0];
    }

    public SecureByteArray(int size) {
        this.data = new byte[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = 0;
        }
    }

    public SecureByteArray(byte[] bytes) {
        this.data = new byte[bytes.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = bytes[i];
        }
    }

    public SecureByteArray(char[] chars) {
        this.data = new byte[chars.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)chars[i];
        }
    }

    public SecureByteArray(SecureByteArray copy) {
        this.data = new byte[copy.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = copy.data[i];
        }
    }

    public SecureByteArray(String str) {
        this.data = str.getBytes();
    }

    static SecureByteArray combine(SecureByteArray a1, SecureByteArray a2) {
        return new SecureByteArray(a1.size() + a2.size());
    }

    public void append(SecureByteArray arr) throws Exception {
        int oldSize = this.size();
        this.resize(this.data.length + arr.data.length, true);
        int i = oldSize;
        int arrI = 0;
        while (i < this.data.length) {
            this.data[i] = arr.data[arrI++];
            ++i;
            ++arrI;
        }
    }

    public void erase() {
        int i;
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = -42;
        }
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = 85;
        }
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = 0;
        }
    }

    public byte getByteAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= 0 && index < this.data.length) {
            return this.data[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public byte[] getData() {
        return this.data;
    }

    public void prepend(SecureByteArray arr) throws Exception {
        int i;
        byte[] olddata = new byte[this.data.length];
        for (i = 0; i < this.data.length; ++i) {
            olddata[i] = this.data[i];
        }
        this.resize(this.size() + arr.size(), false);
        for (i = 0; i < arr.data.length; ++i) {
            this.data[i] = arr.data[i];
        }
        for (i = arr.data.length; i < this.data.length; ++i) {
            this.data[i] = olddata[i - arr.data.length];
        }
        for (i = 0; i < olddata.length; ++i) {
            olddata[i] = 85;
            olddata[i] = -42;
            olddata[i] = 0;
        }
    }

    public void replace(SecureByteArray arr) throws Exception {
        this.erase();
        if (this.data.length != arr.data.length) {
            this.data = new byte[arr.data.length];
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = arr.data[i];
        }
    }

    public void resize(int size, boolean retainData) throws Exception {
        if (size < 0) {
            throw new Exception("Invalid array size");
        }
        byte[] newData = new byte[size];
        if (retainData) {
            int limit = size <= this.data.length ? size : this.data.length;
            for (int i = 0; i < size; ++i) {
                newData[i] = i < limit ? this.data[i] : (byte)0;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                newData[i] = 0;
            }
        }
        this.erase();
        this.data = newData;
    }

    public void setByteAt(int index, byte c) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data[index] = c;
    }

    public int size() {
        return this.data.length;
    }
}

