/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.util.Arrays;

public class SecureCharArray
implements CharSequence {
    private char[] data = null;

    public SecureCharArray() {
        this.data = new char[0];
    }

    public SecureCharArray(int size) {
        this.data = new char[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = '\u0000';
        }
    }

    public SecureCharArray(byte[] bytes) {
        this.data = new char[bytes.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (char)(bytes[i] & 0xFF);
        }
    }

    public SecureCharArray(char[] chars) {
        this.data = new char[chars.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = chars[i];
        }
    }

    public SecureCharArray(SecureCharArray copy) {
        this.data = new char[copy.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = copy.data[i];
        }
    }

    public SecureCharArray(String str) {
        this.data = str.toCharArray();
    }

    static SecureCharArray combine(SecureCharArray a1, SecureCharArray a2) {
        return new SecureCharArray(a1.size() + a2.size());
    }

    public void append(SecureCharArray arr) throws Exception {
        int oldSize = this.size();
        this.resize(this.size() + arr.size(), true);
        int i = oldSize;
        int arrI = 0;
        while (i < this.size()) {
            this.data[i] = arr.data[arrI];
            ++i;
            ++arrI;
        }
    }

    public void erase() {
        int i;
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = 170;
        }
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = 85;
        }
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = '\u0000';
        }
    }

    public char getCharAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= 0 && index < this.data.length) {
            return this.data[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public char[] getData() {
        return this.data;
    }

    public void prepend(SecureCharArray arr) throws Exception {
        int i;
        char[] olddata = new char[this.data.length];
        for (i = 0; i < olddata.length; ++i) {
            olddata[i] = this.data[i];
        }
        this.resize(this.size() + arr.size(), false);
        for (i = 0; i < arr.data.length; ++i) {
            this.data[i] = arr.data[i];
        }
        for (i = arr.data.length; i < this.data.length; ++i) {
            this.data[i] = olddata[i - arr.data.length];
        }
        for (i = 0; i < olddata.length; ++i) {
            olddata[i] = 85;
            olddata[i] = 170;
            olddata[i] = '\u0000';
        }
    }

    public void replace(SecureCharArray arr) throws Exception {
        this.erase();
        if (this.data.length != arr.data.length) {
            this.data = new char[arr.data.length];
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = arr.data[i];
        }
    }

    public void resize(int size, boolean retainData) throws Exception {
        if (size < 0) {
            throw new Exception("Invalid array size");
        }
        char[] newData = new char[size];
        if (retainData) {
            int limit = size <= this.data.length ? size : this.data.length;
            for (int i = 0; i < limit; ++i) {
                newData[i] = i < limit ? this.data[i] : (char)'\u0000';
            }
        } else {
            for (int i = 0; i < size; ++i) {
                newData[i] = '\u0000';
            }
        }
        this.erase();
        this.data = newData;
    }

    public void setCharAt(int index, char c) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.data.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data[index] = c;
    }

    public int size() {
        return this.data.length;
    }

    public char charAt(int index) {
        return this.getCharAt(index);
    }

    public int length() {
        return this.size();
    }

    public CharSequence subSequence(int start, int end) {
        char[] nBuffer = Arrays.copyOfRange(this.data, start, end);
        return new SecureCharArray(nBuffer);
    }
}

