/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import org.daveware.passwordmaker.AccountPatternData;
import org.daveware.passwordmaker.AlgorithmType;
import org.daveware.passwordmaker.ByteArrayUtils;
import org.daveware.passwordmaker.CharacterSets;
import org.daveware.passwordmaker.LeetLevel;
import org.daveware.passwordmaker.LeetType;
import org.daveware.passwordmaker.PasswordMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Account
implements Comparable<Account> {
    private static final Random random = new Random();
    public static final String DEFAULT_ACCOUNT_NAME = "default";
    public static final String DEFAULT_USERNAME = "";
    public static final String ROOT_ACCOUNT_URI = "http://passwordmaker.mozdev.org/accounts";
    public static final String DEFAULT_ACCOUNT_URI = "http://passwordmaker.mozdev.org/defaults";
    public static final int DEFAULT_LENGTH = 8;
    private String name = "";
    private String desc = "";
    private String url = "";
    private String username = "";
    private AlgorithmType algorithm = AlgorithmType.MD5;
    private boolean hmac = false;
    private boolean trim = true;
    private int length = 8;
    private String characterSet = CharacterSets.BASE_93_SET;
    private LeetType leetType = LeetType.NONE;
    private LeetLevel leetLevel = LeetLevel.LEVEL1;
    private String modifier = "";
    private String prefix = "";
    private String suffix = "";
    private boolean sha256Bug = false;
    private String id = "";
    private boolean autoPop = false;
    private EnumSet<UrlComponents> urlComponents = Account.defaultUrlComponents();
    private ArrayList<AccountPatternData> patterns = new ArrayList();
    private ArrayList<Account> children = new ArrayList();
    private boolean isAFolder = false;

    public static Account makeDefaultAccount() {
        Account account = new Account(DEFAULT_ACCOUNT_NAME, DEFAULT_USERNAME, DEFAULT_USERNAME);
        account.addUrlComponent(UrlComponents.Domain);
        account.setId(DEFAULT_ACCOUNT_URI);
        return account;
    }

    public Account() {
    }

    public Account(String name, boolean isFolder) {
        this.isAFolder = isFolder;
        this.name = name;
        this.id = Account.createId();
    }

    public Account(String name, String url, String username) {
        this.name = name;
        this.url = url;
        this.username = username;
        this.id = Account.createIdSilently(url + username);
    }

    public Account(Account toClone) {
        this.copySettings(toClone);
    }

    public Account(String name, String desc, String url, String username, AlgorithmType algorithm, boolean hmac, boolean trim, int length, String characterSet, LeetType leetType, LeetLevel leetLevel, String modifier, String prefix, String suffix, boolean sha256Bug) throws Exception {
        this.name = name;
        this.desc = desc;
        this.url = url;
        this.username = username;
        this.algorithm = algorithm;
        this.hmac = hmac;
        this.trim = trim;
        this.length = length;
        this.characterSet = characterSet;
        this.leetType = leetType;
        this.leetLevel = leetLevel;
        this.modifier = modifier;
        this.prefix = prefix;
        this.suffix = suffix;
        this.sha256Bug = sha256Bug;
        this.id = Account.createId(this.url + this.username);
    }

    public Account(String name, String desc, String url, String username, AlgorithmType algorithm, boolean hmac, boolean trim, int length, String characterSet, LeetType leetType, LeetLevel leetLevel, String modifier, String prefix, String suffix, boolean sha256Bug, String id) {
        this.name = name;
        this.desc = desc;
        this.url = url;
        this.username = username;
        this.algorithm = algorithm;
        this.hmac = hmac;
        this.trim = trim;
        this.length = length;
        this.characterSet = characterSet;
        this.leetType = leetType;
        this.leetLevel = leetLevel;
        this.modifier = modifier;
        this.prefix = prefix;
        this.suffix = suffix;
        this.sha256Bug = sha256Bug;
        this.id = id;
    }

    public static String createId() {
        byte[] buf = new byte[20];
        random.nextBytes(buf);
        return "rdf:#$" + ByteArrayUtils.byteArrayToHexString(buf);
    }

    public static String createId(String str) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA1", PasswordMaker.getDefaultCryptoProvider());
        return "rdf:#$" + ByteArrayUtils.byteArrayToHexString(digest.digest(str.getBytes()));
    }

    private static String createIdSilently(String str) {
        try {
            return Account.createId(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String createId(Account acc) throws Exception {
        return Account.createId(acc.getName() + acc.getDesc() + new Random().nextLong() + Runtime.getRuntime().freeMemory());
    }

    private static EnumSet<UrlComponents> defaultUrlComponents() {
        return EnumSet.noneOf(UrlComponents.class);
    }

    public void copySettings(Account a) {
        this.name = a.name;
        this.desc = a.desc;
        this.url = a.url;
        this.username = a.username;
        this.algorithm = a.algorithm;
        this.hmac = a.hmac;
        this.trim = a.trim;
        this.length = a.length;
        this.characterSet = a.characterSet;
        this.leetType = a.leetType;
        this.leetLevel = a.leetLevel;
        this.modifier = a.modifier;
        this.prefix = a.prefix;
        this.suffix = a.suffix;
        this.sha256Bug = a.sha256Bug;
        this.isAFolder = a.isAFolder;
        this.autoPop = a.autoPop;
        this.patterns.clear();
        for (AccountPatternData data : a.getPatterns()) {
            this.patterns.add(new AccountPatternData(data));
        }
        this.urlComponents = !a.urlComponents.isEmpty() ? EnumSet.copyOf(a.urlComponents) : Account.defaultUrlComponents();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String s) {
        this.desc = s;
    }

    public boolean isFolder() {
        return this.isAFolder;
    }

    public boolean isAutoPop() {
        return this.autoPop;
    }

    public void setAutoPop(boolean b) {
        this.autoPop = b;
    }

    public boolean isDefault() {
        return this.id.compareTo(DEFAULT_ACCOUNT_URI) == 0;
    }

    public boolean isRoot() {
        return this.id.compareTo(ROOT_ACCOUNT_URI) == 0;
    }

    public void setIsFolder(boolean b) {
        this.isAFolder = b;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public boolean isHmac() {
        return this.hmac;
    }

    public void setHmac(boolean hmac) {
        this.hmac = hmac;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
        if (!trim) {
            this.setCharacterSet(CharacterSets.HEX);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        if (!this.isTrim()) {
            characterSet = CharacterSets.HEX;
        }
        this.characterSet = characterSet;
    }

    public LeetType getLeetType() {
        return this.leetType;
    }

    public void setLeetType(LeetType leetType) {
        this.leetType = leetType;
    }

    public LeetLevel getLeetLevel() {
        return this.leetLevel;
    }

    public void setLeetLevel(LeetLevel leetLevel) {
        this.leetLevel = leetLevel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isSha256Bug() {
        return this.sha256Bug;
    }

    public void setSha256Bug(boolean sha256Bug) {
        this.sha256Bug = sha256Bug;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public final void clearUrlComponents() {
        this.urlComponents.clear();
    }

    public final void addUrlComponent(UrlComponents urlComponent) {
        this.urlComponents.add(urlComponent);
    }

    public final void removeUrlComponent(UrlComponents urlComponent) {
        this.urlComponents.remove((Object)urlComponent);
    }

    public final Set<UrlComponents> getUrlComponents() {
        return Collections.unmodifiableSet(this.urlComponents);
    }

    public final void setUrlComponents(Set<UrlComponents> urlComponents) {
        this.urlComponents.clear();
        this.urlComponents.addAll(urlComponents);
    }

    public ArrayList<Account> getChildren() {
        return this.children;
    }

    public int getNestedChildCount() {
        ArrayList<Account> stack = new ArrayList<Account>();
        int size = 0;
        stack.add(this);
        while (stack.size() > 0) {
            Account current = (Account)stack.get(0);
            stack.remove(0);
            for (Account child : current.getChildren()) {
                ++size;
                if (!child.hasChildren()) continue;
                stack.add(child);
            }
        }
        return size;
    }

    public Account getChild(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.children.size()) {
            throw new IndexOutOfBoundsException("Illegal child index, " + index);
        }
        return this.children.get(index);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean hasChild(Account account) {
        for (Account child : this.children) {
            if (!child.equals(account)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Account o) {
        if (this.isFolder() && !o.isFolder()) {
            return -1;
        }
        if (!this.isFolder() && o.isFolder()) {
            return 1;
        }
        int result = this.name.compareToIgnoreCase(o.name);
        if (result == 0) {
            return this.name.compareTo(o.name);
        }
        return result;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account thatAccount = (Account)o;
        return thatAccount.id.compareTo(this.id) == 0;
    }

    public ArrayList<AccountPatternData> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Iterable<AccountPatternData> patterns) {
        this.patterns.clear();
        for (AccountPatternData data : patterns) {
            this.patterns.add(new AccountPatternData(data));
        }
    }

    public String toString() {
        return this.name;
    }

    public String toDebugString() {
        return "Account{name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + ", url='" + this.url + '\'' + ", isDefault=" + this.isDefault() + ", isRoot=" + this.isRoot() + ", username='" + this.username + '\'' + ", algorithm=" + this.algorithm + ", hmac=" + this.hmac + ", trim=" + this.trim + ", length=" + this.length + ", characterSet='" + this.characterSet + '\'' + ", leetType=" + this.leetType + ", leetLevel=" + this.leetLevel + ", modifier='" + this.modifier + '\'' + ", prefix='" + this.prefix + '\'' + ", suffix='" + this.suffix + '\'' + ", sha256Bug=" + this.sha256Bug + ", id='" + this.id + '\'' + ", autoPop=" + this.autoPop + ", urlComponents=" + this.urlComponents + ", patterns=" + this.patterns + ", children=" + this.children + ", isAFolder=" + this.isAFolder + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UrlComponents {
        Protocol,
        Subdomain,
        Domain,
        PortPathAnchorQuery;

    }
}

