/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.daveware.passwordmaker.Account;
import org.daveware.passwordmaker.AccountPatternData;
import org.daveware.passwordmaker.AccountPatternType;

public class AccountPatternMatcher {
    public static boolean matchUrl(Account account, String url) {
        for (AccountPatternData pattern : account.getPatterns()) {
            AccountPatternType type = pattern.getType();
            if (type == AccountPatternType.REGEX) {
                if (!AccountPatternMatcher.regexMatch(pattern.getPattern(), url)) continue;
                return true;
            }
            if (type == AccountPatternType.WILDCARD) {
                if (!AccountPatternMatcher.globMatch(pattern.getPattern(), url)) continue;
                return true;
            }
            Logger logger = Logger.getLogger(AccountPatternMatcher.class.getName());
            logger.warning("Unknown pattern match type '" + type.toString() + "' for account '" + account.getName() + "' id='" + account.getId() + "'");
        }
        return account.getUrl().equalsIgnoreCase(url);
    }

    private static boolean regexMatch(String regex, String text) {
        return Pattern.matches(regex, text);
    }

    private static boolean globMatch(String glob, String text) {
        GlobMatch m = new GlobMatch();
        return m.match(text, glob);
    }

    private static class GlobMatch {
        private String text;
        private String pattern;

        public boolean match(String text, String pattern) {
            this.text = text;
            this.pattern = pattern;
            if (text.isEmpty()) {
                return this.doesMatchOnEmpty();
            }
            return this.matchCharacter(0, 0);
        }

        private boolean doesMatchOnEmpty() {
            return this.pattern.isEmpty() || this.pattern.equals("*");
        }

        private boolean matchCharacter(int patternIndex, int textIndex) {
            if (patternIndex >= this.pattern.length()) {
                return false;
            }
            switch (this.pattern.charAt(patternIndex)) {
                case '?': {
                    if (textIndex < this.text.length()) break;
                    return false;
                }
                case '*': {
                    if (patternIndex + 1 >= this.pattern.length() || textIndex >= this.text.length()) {
                        return true;
                    }
                    while (textIndex < this.text.length()) {
                        if (this.matchCharacter(patternIndex + 1, textIndex)) {
                            return true;
                        }
                        ++textIndex;
                    }
                    return false;
                }
                default: {
                    String patternChar;
                    if (textIndex >= this.text.length()) {
                        return false;
                    }
                    String textChar = this.text.substring(textIndex, textIndex + 1);
                    if (textChar.compareToIgnoreCase(patternChar = this.pattern.substring(patternIndex, patternIndex + 1)) == 0) break;
                    return false;
                }
            }
            if (patternIndex + 1 >= this.pattern.length() && textIndex + 1 >= this.text.length()) {
                return true;
            }
            return this.matchCharacter(patternIndex + 1, textIndex + 1);
        }
    }
}

