/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.daveware.passwordmaker.Account;
import org.daveware.passwordmaker.AccountPatternData;
import org.daveware.passwordmaker.AccountPatternType;
import org.daveware.passwordmaker.Database;
import org.daveware.passwordmaker.DatabaseWriter;
import org.daveware.passwordmaker.xmlwrappers.DefaultXmlStreamWriter;
import org.daveware.passwordmaker.xmlwrappers.XmlIOException;
import org.daveware.passwordmaker.xmlwrappers.XmlStreamWriter;
import org.xml.sax.InputSource;

public class RDFDatabaseWriter
implements DatabaseWriter {
    Logger logger = Logger.getLogger(this.getClass().toString());

    private String formatXml(String xml) throws Exception {
        Transformer serializer = SAXTransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes())));
        StreamResult res = new StreamResult(new ByteArrayOutputStream());
        serializer.transform(xmlSource, res);
        return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray());
    }

    protected XmlStreamWriter newXmlStreamWriter(Writer writer) throws XmlIOException {
        return new DefaultXmlStreamWriter(writer);
    }

    @Override
    public void write(OutputStream os, Database db) throws Exception {
        try {
            StringWriter sWriter = new StringWriter();
            XmlStreamWriter writer = this.newXmlStreamWriter(sWriter);
            writer.writeStartDocument();
            writer.writeStartElement("RDF:RDF");
            writer.addPrefix("NS1", "http://passwordmaker.mozdev.org/rdf#");
            writer.addPrefix("NC", "http://home.netscape.com/NC-rdf#");
            writer.addPrefix("RDF", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.writeParent(db.getRootAccount(), writer);
            this.writeFFGlobalSettings(db, writer);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            sWriter.flush();
            sWriter.close();
            String pretty = this.formatXml(sWriter.toString());
            BufferedWriter bWriter = new BufferedWriter(new OutputStreamWriter(os));
            bWriter.write(pretty);
            bWriter.flush();
            bWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeAccount(OutputStream os, Account account) throws Exception {
        OutputStreamWriter streamWriter = new OutputStreamWriter(os, "UTF-8");
        XmlStreamWriter writer = this.newXmlStreamWriter(streamWriter);
        try {
            writer.writeStartDocument("UTF-8", "1.0");
            this.writeDescription(account, writer);
            writer.writeEndDocument();
            writer.close();
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable ignored) {}
        }
    }

    private void writeDescription(Account account, XmlStreamWriter writer) throws Exception {
        writer.writeStartElement("RDF:Description");
        writer.writeAttribute("RDF:about", account.getId());
        writer.writeAttribute("NS1:name", account.getName());
        writer.writeAttribute("NS1:description", account.getDesc());
        if (!account.isFolder()) {
            writer.writeAttribute("NS1:whereLeetLB", account.getLeetType().toRdfString());
            writer.writeAttribute("NS1:leetLevelLB", Integer.toString(account.getLeetLevel().getLevel()));
            if (account.isHmac()) {
                writer.writeAttribute("NS1:hashAlgorithmLB", account.getAlgorithm().toHmacRdfString());
            } else {
                writer.writeAttribute("NS1:hashAlgorithmLB", account.getAlgorithm().toRdfString());
            }
            writer.writeAttribute("NS1:passwordLength", Integer.toString(account.getLength()));
            writer.writeAttribute("NS1:usernameTB", account.getUsername());
            writer.writeAttribute("NS1:counter", account.getModifier());
            writer.writeAttribute("NS1:charset", account.getCharacterSet());
            writer.writeAttribute("NS1:prefix", account.getPrefix());
            writer.writeAttribute("NS1:suffix", account.getSuffix());
            writer.writeAttribute("NS1:autoPopulate", "false");
            Set<Account.UrlComponents> urlComponents = account.getUrlComponents();
            if (!urlComponents.isEmpty()) {
                writer.writeAttribute("NS1:protocolCB", urlComponents.contains((Object)Account.UrlComponents.Protocol) ? "true" : "false");
                writer.writeAttribute("NS1:subdomainCB", urlComponents.contains((Object)Account.UrlComponents.Subdomain) ? "true" : "false");
                writer.writeAttribute("NS1:domainCB", urlComponents.contains((Object)Account.UrlComponents.Domain) ? "true" : "false");
                writer.writeAttribute("NS1:pathCB", urlComponents.contains((Object)Account.UrlComponents.PortPathAnchorQuery) ? "true" : "false");
            }
            if (urlComponents.isEmpty() || !account.getUrl().isEmpty()) {
                writer.writeAttribute("NS1:urlToUse", account.getUrl());
            }
            int patternCount = 0;
            for (AccountPatternData data : account.getPatterns()) {
                writer.writeAttribute("NS1:pattern" + patternCount, data.getPattern());
                if (data.getType() == AccountPatternType.WILDCARD) {
                    writer.writeAttribute("NS1:patterntype" + patternCount, "wildcard");
                } else {
                    writer.writeAttribute("NS1:patterntype" + patternCount, "regex");
                }
                writer.writeAttribute("NS1:patternenabled" + patternCount, "true");
                writer.writeAttribute("NS1:patterndesc" + patternCount, data.getDesc());
                ++patternCount;
            }
        }
        writer.writeEndElement();
    }

    private void writeParent(Account account, XmlStreamWriter writer) throws Exception {
        writer.writeStartElement("RDF:Seq");
        writer.writeAttribute("RDF:about", account.getId());
        for (Account child : account.getChildren()) {
            this.logger.fine("    Write-RDF:li: " + child.getId());
            writer.writeStartElement("RDF:li");
            writer.writeAttribute("RDF:resource", child.getId());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        this.writeDescription(account, writer);
        for (Account child : account.getChildren()) {
            this.logger.fine("Write-RDF:Desc: " + child.getName());
            this.writeDescription(child, writer);
        }
        for (Account child : account.getChildren()) {
            if (child.getChildren().size() <= 0) continue;
            this.writeParent(child, writer);
        }
    }

    private void writeFFGlobalSettings(Database db, XmlStreamWriter writer) throws Exception {
        writer.writeStartElement("RDF:Description");
        writer.writeAttribute("RDF:about", "http://passwordmaker.mozdev.org/globalSettings");
        for (String key : db.getGlobalSettings().keySet()) {
            writer.writeAttribute(key, db.getGlobalSettings().get(key));
        }
        writer.writeEndElement();
    }
}

