/*
 * Decompiled with CFR 0.152.
 */
package org.daveware.passwordmaker;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class StringEncodingUtils {
    public static String ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] charArrayToBytesUTFNIO(char[] buffer) {
        CharBuffer charBuffer = CharBuffer.wrap(buffer);
        ByteBuffer byteBuffer = Charset.forName(ENCODING).encode(charBuffer);
        try {
            byte[] byArray = StringEncodingUtils.byteBufferToBytes(byteBuffer);
            return byArray;
        }
        finally {
            StringEncodingUtils.eraseByteBuffer(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] bytesToCharArrayUTFNIO(byte[] buffer) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        CharBuffer charBuffer = Charset.forName(ENCODING).decode(byteBuffer);
        try {
            char[] cArray = StringEncodingUtils.charBufferToChars(charBuffer);
            return cArray;
        }
        finally {
            StringEncodingUtils.eraseCharBuffer(charBuffer);
        }
    }

    public static byte[] byteBufferToBytes(ByteBuffer buffer) {
        byte[] array = buffer.array();
        int arrayOffset = buffer.arrayOffset();
        return Arrays.copyOfRange(array, arrayOffset + buffer.position(), arrayOffset + buffer.limit());
    }

    public static char[] charBufferToChars(CharBuffer buffer) {
        char[] array = buffer.array();
        int arrayOffset = buffer.arrayOffset();
        return Arrays.copyOfRange(array, arrayOffset + buffer.position(), arrayOffset + buffer.limit());
    }

    public static void eraseCharBuffer(CharBuffer buffer) {
        char[] data = buffer.array();
        long limit = buffer.arrayOffset() + buffer.limit();
        int i = buffer.arrayOffset();
        while ((long)i < limit) {
            data[i] = 170;
            ++i;
        }
        i = buffer.arrayOffset();
        while ((long)i < limit) {
            data[i] = 85;
            ++i;
        }
        i = buffer.arrayOffset();
        while ((long)i < limit) {
            data[i] = '\u0000';
            ++i;
        }
    }

    public static void eraseByteBuffer(ByteBuffer buffer) {
        byte[] data = buffer.array();
        long limit = buffer.arrayOffset() + buffer.limit();
        int i = buffer.arrayOffset();
        while ((long)i < limit) {
            data[i] = -86;
            ++i;
        }
        i = buffer.arrayOffset();
        while ((long)i < limit) {
            data[i] = 85;
            ++i;
        }
        i = buffer.arrayOffset();
        while ((long)i < limit) {
            data[i] = 0;
            ++i;
        }
    }

    public static byte[] stringAsUTF8ByteArray(String str) {
        try {
            return str.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

