/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.eventstudio;

import java.lang.ref.Reference;
import org.pdfsam.eventstudio.util.RequireUtils;

interface Entity<T> {
    public T get();

    public static class StrongEntity<T>
    implements Entity<T> {
        private T referent;

        StrongEntity(T referent) {
            this.referent = referent;
        }

        @Override
        public T get() {
            return this.referent;
        }
    }

    public static class ReferencedEntity<T>
    implements Entity<T> {
        private Reference<T> reference;

        ReferencedEntity(Reference<T> reference) {
            RequireUtils.requireNotNull(reference);
            this.reference = reference;
        }

        @Override
        public T get() {
            return this.reference.get();
        }
    }
}

