/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.eventstudio;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pdfsam.eventstudio.Annotations;
import org.pdfsam.eventstudio.Entity;
import org.pdfsam.eventstudio.Envelope;
import org.pdfsam.eventstudio.Listener;
import org.pdfsam.eventstudio.ReferenceStrength;
import org.pdfsam.eventstudio.exception.BroadcastInterruptionException;
import org.pdfsam.eventstudio.exception.EventStudioException;
import org.pdfsam.eventstudio.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Listeners {
    private static final Logger LOG = LoggerFactory.getLogger(Listeners.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<Class<?>, TreeSet<ListenerReferenceHolder>> listeners = new HashMap();

    Listeners() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void add(Class<T> eventClass, Listener<T> listener, int priority, ReferenceStrength strength) {
        this.lock.writeLock().lock();
        try {
            TreeSet<ListenerReferenceHolder> set = this.nullSafeGetListenerHolders(eventClass);
            set.add(new ListenerReferenceHolder(priority, strength.getReference(new DefaultListenerWrapper(listener))));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Class<?>> addAll(Object bean, List<Annotations.ReflectiveListenerDescriptor> descriptors) {
        HashSet updatedEventClasses = new HashSet();
        this.lock.writeLock().lock();
        try {
            for (Annotations.ReflectiveListenerDescriptor current : descriptors) {
                Class<?> eventClass = current.getMethod().getParameterTypes()[0];
                TreeSet<ListenerReferenceHolder> set = this.nullSafeGetListenerHolders(eventClass);
                set.add(new ListenerReferenceHolder(current.getListenerAnnotation().priority(), current.getListenerAnnotation().strength().getReference(new ReflectiveListenerWrapper(bean, current.getMethod()))));
                updatedEventClasses.add(eventClass);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return updatedEventClasses;
    }

    private TreeSet<ListenerReferenceHolder> nullSafeGetListenerHolders(Class<?> eventClass) {
        TreeSet<ListenerReferenceHolder> set = this.listeners.get(eventClass);
        if (set == null) {
            set = new TreeSet();
            this.listeners.put(eventClass, set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean remove(Class<T> eventClass, Listener<T> listener) {
        this.lock.readLock().lock();
        TreeSet<ListenerReferenceHolder> set = this.listeners.get(eventClass);
        if (set != null) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                DefaultListenerWrapper wrapper = new DefaultListenerWrapper(listener);
                for (ListenerReferenceHolder current : set) {
                    if (!wrapper.equals(current.getListenerWrapper())) continue;
                    boolean bl = this.removeListenerAndSetIfNeeded(eventClass, current, set);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().unlock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Class<?> eventClass, ListenerReferenceHolder listener) {
        this.lock.readLock().lock();
        TreeSet<ListenerReferenceHolder> set = this.listeners.get(eventClass);
        if (set != null) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                boolean bl = this.removeListenerAndSetIfNeeded(eventClass, listener, set);
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().unlock();
        return false;
    }

    private boolean removeListenerAndSetIfNeeded(Class<?> eventClass, ListenerReferenceHolder listener, TreeSet<ListenerReferenceHolder> set) {
        if (set.remove(listener)) {
            if (set.isEmpty()) {
                this.listeners.remove(eventClass);
                LOG.trace("Removed empty listeners set for {}", eventClass);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ListenerReferenceHolder> nullSafeGetListeners(Class<?> eventClass) {
        RequireUtils.requireNotNull(eventClass);
        this.lock.readLock().lock();
        try {
            TreeSet<ListenerReferenceHolder> set = this.listeners.get(eventClass);
            if (set == null) {
                List<ListenerReferenceHolder> list = Collections.emptyList();
                return list;
            }
            ArrayList<ListenerReferenceHolder> arrayList = new ArrayList<ListenerReferenceHolder>(set);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    static class ListenerReferenceHolder
    implements Comparable<ListenerReferenceHolder> {
        int priority = 0;
        private Entity<? extends ListenerWrapper> reference;

        public ListenerReferenceHolder(int priority, Entity<? extends ListenerWrapper> reference) {
            RequireUtils.requireNotNull(reference);
            this.priority = priority;
            this.reference = reference;
        }

        @Override
        public int compareTo(ListenerReferenceHolder o) {
            if (this.priority < o.priority) {
                return -1;
            }
            if (this.priority > o.priority) {
                return 1;
            }
            int retVal = this.hashCode() - o.hashCode();
            if (retVal == 0 && !this.equals(o)) {
                retVal = -1;
            }
            return retVal;
        }

        public ListenerWrapper getListenerWrapper() {
            return this.reference.get();
        }
    }

    private static final class ReflectiveListenerWrapper
    implements ListenerWrapper {
        private Object bean;
        private Method method;

        public ReflectiveListenerWrapper(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
            this.method.setAccessible(true);
        }

        @Override
        public void onEvent(Envelope event) {
            try {
                this.method.invoke(this.bean, event.getEvent());
            }
            catch (IllegalAccessException e) {
                throw new EventStudioException("Exception invoking reflective method", e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof BroadcastInterruptionException) {
                    throw (BroadcastInterruptionException)e.getCause();
                }
                throw new EventStudioException("Reflective method invocation exception", e);
            }
            event.notified();
        }
    }

    private static final class DefaultListenerWrapper
    implements ListenerWrapper {
        private Listener wrapped;

        private DefaultListenerWrapper(Listener wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void onEvent(Envelope event) {
            this.wrapped.onEvent(event.getEvent());
            event.notified();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.wrapped == null ? 0 : this.wrapped.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof DefaultListenerWrapper)) {
                return false;
            }
            DefaultListenerWrapper other = (DefaultListenerWrapper)o;
            return this.wrapped.equals(other.wrapped);
        }
    }

    static interface ListenerWrapper {
        public void onEvent(Envelope var1);
    }
}

