/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.eventstudio;

import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.pdfsam.eventstudio.Annotations;
import org.pdfsam.eventstudio.Envelope;
import org.pdfsam.eventstudio.Listener;
import org.pdfsam.eventstudio.Listeners;
import org.pdfsam.eventstudio.ReferenceStrength;
import org.pdfsam.eventstudio.Supervisor;
import org.pdfsam.eventstudio.exception.BroadcastInterruptionException;
import org.pdfsam.eventstudio.exception.EventStudioException;
import org.pdfsam.eventstudio.util.ReflectionUtils;
import org.pdfsam.eventstudio.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Station {
    private static final Logger LOG = LoggerFactory.getLogger(Station.class);
    private final ConcurrentMap<Class<?>, BlockingQueue<Object>> queues = new ConcurrentHashMap();
    private final Listeners listeners = new Listeners();
    private volatile Supervisor supervisor = Supervisor.SLACKER;
    private final String name;

    Station(String name) {
        RequireUtils.requireNotBlank(name);
        this.name = name;
    }

    private BlockingQueue<Object> getQueue(Class<?> clazz) {
        LinkedBlockingQueue value;
        LinkedBlockingQueue queue = (LinkedBlockingQueue)this.queues.get(clazz);
        if (queue == null && (queue = (BlockingQueue)this.queues.putIfAbsent(clazz, value = new LinkedBlockingQueue(Integer.getInteger("eventstudio.max.queue.size", Integer.MAX_VALUE)))) == null) {
            queue = value;
        }
        return queue;
    }

    public void broadcast(Object event) {
        LOG.debug("{}: Broadcasting {}", (Object)this, event);
        RequireUtils.requireNotNull(event);
        LOG.trace("{}: Supervisor {} about to inspect", (Object)this, (Object)this.supervisor);
        this.supervisor.inspect(event);
        LOG.trace("{}: Listeners about to listen", (Object)this);
        try {
            this.doBroadcast(event);
        }
        catch (BroadcastInterruptionException e) {
            LOG.info("Broadcasting was interrupted.", (Throwable)e);
        }
    }

    private boolean doBroadcast(Object event) {
        List<Listeners.ListenerReferenceHolder> eventListeners = this.listeners.nullSafeGetListeners(event.getClass());
        LOG.debug("{}: Found {} listeners", (Object)this, (Object)eventListeners.size());
        Envelope enveloped = new Envelope(event);
        for (Listeners.ListenerReferenceHolder holder : eventListeners) {
            Listeners.ListenerWrapper listener = holder.getListenerWrapper();
            if (listener != null) {
                LOG.trace("{}: Notifing event {} to {}", new Object[]{this, event, listener});
                listener.onEvent(enveloped);
                continue;
            }
            LOG.debug("{}: Removing garbage collected listener from the station", (Object)this);
            this.listeners.remove(event.getClass(), holder);
        }
        if (!enveloped.isNotified()) {
            LOG.debug("{}: No one is listening for {}, enqueuing for future listeners", (Object)this, event);
            if (!this.getQueue(event.getClass()).offer(event)) {
                LOG.warn("{}: Max capacity might be reached, unable to store unlistened event, it's going to be lost {}", (Object)this, event);
            }
        }
        return enveloped.isNotified();
    }

    <T> void add(Listener<T> listener, int priority, ReferenceStrength strength) {
        RequireUtils.requireNotNull(listener);
        Class eventClass = ReflectionUtils.inferParameterClass(listener.getClass(), "onEvent");
        if (eventClass == null) {
            throw new EventStudioException("Unable to infer the listened event class.");
        }
        this.add(eventClass, listener, priority, strength);
    }

    <T> void add(Class<T> eventClass, Listener<T> listener, int priority, ReferenceStrength strength) {
        RequireUtils.requireNotNull(eventClass);
        RequireUtils.requireNotNull(listener);
        LOG.debug("{}: Adding listener {} [priority={} strength={}]", new Object[]{this, listener, priority, strength});
        this.listeners.add(eventClass, listener, priority, strength);
        this.broadcastEnqueuedEventsFor(eventClass);
    }

    void addAll(Object bean, List<Annotations.ReflectiveListenerDescriptor> descriptors) {
        RequireUtils.requireNotNull(descriptors);
        LOG.debug("{}: Adding {} reflective listeners for {}", new Object[]{this, descriptors.size(), bean});
        Set<Class<?>> updatedEventClasses = this.listeners.addAll(bean, descriptors);
        for (Class<?> updatedClass : updatedEventClasses) {
            this.broadcastEnqueuedEventsFor(updatedClass);
        }
    }

    private void broadcastEnqueuedEventsFor(Class<?> updatedClass) {
        BlockingQueue<Object> queue = this.getQueue(updatedClass);
        Object event = null;
        boolean keepBroadcasting = true;
        while (keepBroadcasting) {
            Object e = queue.poll();
            event = e;
            if (e == null) break;
            LOG.debug("{}: Found enqueued event {}, now broadcasting it.", (Object)this, event);
            keepBroadcasting = this.doBroadcast(event);
        }
    }

    <T> boolean remove(Listener<T> listener) {
        RequireUtils.requireNotNull(listener);
        Class eventClass = ReflectionUtils.inferParameterClass(listener.getClass(), "onEvent");
        if (eventClass == null) {
            throw new EventStudioException("Unable to infer the listened event class.");
        }
        return this.remove(eventClass, listener);
    }

    <T> boolean remove(Class<T> eventClass, Listener<T> listener) {
        RequireUtils.requireNotNull(eventClass);
        RequireUtils.requireNotNull(listener);
        LOG.debug("{}: Removing listener {} [eventClass={}]", new Object[]{this, listener, eventClass});
        return this.listeners.remove(eventClass, listener);
    }

    String name() {
        return this.name;
    }

    public void supervior(Supervisor supervisor) {
        RequireUtils.requireNotNull(supervisor);
        this.supervisor = supervisor;
    }

    public String toString() {
        return String.format("Station[%s]", this.name);
    }
}

