/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.eventstudio;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.eventstudio.exception.EventStudioException;
import org.pdfsam.eventstudio.util.RequireUtils;
import org.pdfsam.eventstudio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Annotations {
    private static final Logger LOG = LoggerFactory.getLogger(Annotations.class);

    private Annotations() {
    }

    public static ReflectiveMetadata process(Object bean) throws IllegalAccessException, InvocationTargetException {
        RequireUtils.requireNotNull(bean);
        LOG.trace("Processing {} for annotated listeners", bean);
        String station = Annotations.getStationNameFromFieldIfAny(bean);
        ReflectiveMetadata metadata = new ReflectiveMetadata();
        for (Method method : Annotations.getMethods(bean)) {
            if (StringUtils.isBlank(station)) {
                station = Annotations.getStationNameIfAnnotated(method, bean);
            }
            Annotations.addIfAnnotated(metadata, method);
        }
        metadata.station = station;
        return metadata;
    }

    private static List<Method> getMethods(Object bean) {
        LinkedList<Method> methods = new LinkedList<Method>(Arrays.asList(bean.getClass().getMethods()));
        for (Method method : bean.getClass().getDeclaredMethods()) {
            if (Modifier.isPublic(method.getModifiers())) continue;
            methods.add(method);
        }
        return methods;
    }

    private static void addIfAnnotated(ReflectiveMetadata metadata, Method method) {
        EventListener listenerAnnotation = method.getAnnotation(EventListener.class);
        if (listenerAnnotation != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new EventStudioException("@EventListener annotated method expected to be a single parameter method");
            }
            LOG.trace("Found @EventListener annotated method {}", (Object)method);
            metadata.put(listenerAnnotation.station(), new ReflectiveListenerDescriptor(listenerAnnotation, method));
        }
    }

    private static String getStationNameIfAnnotated(Method method, Object bean) throws InvocationTargetException, IllegalAccessException {
        if (method.isAnnotationPresent(EventStation.class)) {
            if (method.getParameterTypes().length > 0) {
                throw new EventStudioException("@EventStation annotated method expected to be a no parameters method.");
            }
            method.setAccessible(true);
            LOG.trace("Found @EventStation annotated method {}", (Object)method);
            if (method.getReturnType().isEnum()) {
                return method.invoke(bean, new Object[0]).toString();
            }
            return (String)method.invoke(bean, new Object[0]);
        }
        return null;
    }

    private static String getStationNameFromFieldIfAny(Object bean) throws IllegalAccessException {
        for (Field field : bean.getClass().getDeclaredFields()) {
            if (field.getAnnotation(EventStation.class) == null) continue;
            field.setAccessible(true);
            Object value = field.get(bean);
            if (value.getClass().isEnum()) {
                return value.toString();
            }
            return (String)value;
        }
        return null;
    }

    static class ReflectiveMetadata {
        private String station;
        private final Map<String, List<ReflectiveListenerDescriptor>> descriptors = new HashMap<String, List<ReflectiveListenerDescriptor>>();

        ReflectiveMetadata() {
        }

        private void put(String station, ReflectiveListenerDescriptor descriptor) {
            List current = this.descriptors.computeIfAbsent(station, k -> new ArrayList());
            current.add(descriptor);
        }

        public String getStation() {
            return this.station;
        }

        public Map<String, List<ReflectiveListenerDescriptor>> getDescriptors() {
            return this.descriptors;
        }
    }

    record ReflectiveListenerDescriptor(EventListener listenerAnnotation, Method method) {
    }
}

