/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.backpages;

import jakarta.inject.Named;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolDescriptor;
import org.pdfsam.model.tool.ToolDescriptorBuilder;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.tool.ToolPriority;
import org.pdfsam.tools.backpages.AddBackpagesToolPanel;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.io.BrowsablePdfOutputField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.tool.Footer;
import org.pdfsam.ui.components.tool.OpenButton;
import org.pdfsam.ui.components.tool.RunButton;

public class AddBackpagesTool
implements Tool {
    static final String TOOL_ID = "addbackpages";
    private final ToolDescriptor descriptor = ToolDescriptorBuilder.builder().category(ToolCategory.MERGE).inputTypes(new ToolInputOutputType[]{ToolInputOutputType.SINGLE_PDF}).name(I18nContext.i18n().tr("Insert pages multiple times")).description(I18nContext.i18n().tr("Insert the pages of a PDF document A into another document B, repeating it after a certain number of pages, resulting in B1 A B2 A B3 A etc.")).priority(ToolPriority.DEFAULT.getPriority()).supportURL("https://pdfsam.org/insert-pdf-multiple-times/").build();

    public ToolDescriptor descriptor() {
        return this.descriptor;
    }

    public Pane panel() {
        return (Pane)ApplicationContext.app().instance(AddBackpagesToolPanel.class);
    }

    public String id() {
        return TOOL_ID;
    }

    public Node graphic() {
        FontIcon icon = new FontIcon((Ikon)UniconsLine.ALIGN_LETTER_RIGHT);
        icon.getStyleClass().addAll((Object[])new String[]{this.descriptor().category().styleClass(), "tool-icon"});
        return icon;
    }

    public static class ModuleConfig {
        @Provides
        @Named(value="addbackpagesfield")
        public BrowsablePdfOutputField destinationFileField() {
            return new BrowsablePdfOutputField();
        }

        @Provides
        @Named(value="addbackpagespane")
        public PdfDestinationPane destinationPane(@Named(value="addbackpagesfield") BrowsablePdfOutputField outputField) {
            return new PdfDestinationPane((BrowsableField)outputField, AddBackpagesTool.TOOL_ID, new PdfDestinationPane.DestinationPanelFields[0]);
        }

        @Provides
        @Named(value="addbackpagesfooter")
        public Footer footer(RunButton runButton, @Named(value="addbackpagesopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, AddBackpagesTool.TOOL_ID);
        }

        @Provides
        @Named(value="addbackpagesopenButton")
        public OpenButton openButton() {
            return new OpenButton(AddBackpagesTool.TOOL_ID, ToolInputOutputType.SINGLE_PDF);
        }
    }
}

