/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.backpages;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.SinglePdfSourceTaskParametersBuilder;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.tools.backpages.AddBackpagesPane;
import org.pdfsam.tools.backpages.AddBackpagesParametersBuilder;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.io.BrowsablePdfOutputField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.selection.single.TaskParametersBuilderSingleSelectionPane;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Views;
import org.pdfsam.ui.components.tool.BaseToolPanel;
import org.pdfsam.ui.components.tool.Footer;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.SingleOrMultipleTaskOutput;

public class AddBackpagesToolPanel
extends BaseToolPanel {
    private final TaskParametersBuilderSingleSelectionPane selectionPane;
    private final BrowsablePdfOutputField destinationFileField;
    private final PdfDestinationPane destinationPane;
    private final AddBackpagesPane addBackpagesOptions;

    @Inject
    public AddBackpagesToolPanel(@Named(value="addbackpagesfield") BrowsablePdfOutputField destinationFileField, @Named(value="addbackpagespane") PdfDestinationPane destinationPane, @Named(value="addbackpagesfooter") Footer footer) {
        super("addbackpages", footer);
        this.destinationFileField = destinationFileField;
        this.destinationPane = destinationPane;
        this.addBackpagesOptions = new AddBackpagesPane("addbackpages");
        this.selectionPane = new TaskParametersBuilderSingleSelectionPane(this.id());
        this.selectionPane.setPromptText(I18nContext.i18n().tr("Select or drag and drop the PDF you want to insert pages to"));
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.addBackpagesOptions.saveStateTo(data);
        this.destinationFileField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.addBackpagesOptions.restoreStateFrom(data);
        this.destinationFileField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
    }

    protected AddBackpagesParametersBuilder getBuilder(Consumer<String> onError) {
        AddBackpagesParametersBuilder builder = new AddBackpagesParametersBuilder();
        this.selectionPane.apply((SinglePdfSourceTaskParametersBuilder)builder, onError);
        this.addBackpagesOptions.apply(builder, onError);
        ValidableTextField destinationField = this.destinationFileField.getTextField();
        destinationField.validate();
        if (destinationField.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.output((SingleOrMultipleTaskOutput)FileOrDirectoryTaskOutput.file((File)new File(destinationField.getText())));
        } else {
            onError.accept(I18nContext.i18n().tr("A .pdf destination file extension is required"));
        }
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        return builder;
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)I18nContext.i18n().tr("Insert and Repeat settings"), (Node)this.addBackpagesOptions), Views.titledPane((String)I18nContext.i18n().tr("Destination file"), (Node)this.destinationPane)});
        return pane;
    }

    @EventStation
    public String id() {
        return "addbackpages";
    }

    @EventListener
    public void onClearModule(ClearToolRequest e) {
        if (e.clearEverything()) {
            this.addBackpagesOptions.resetView();
            this.destinationPane.resetView();
        }
    }
}

