/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.AppContainer;
import org.pdfsam.gui.components.content.news.NewsPanel;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.news.HideNewsPanelRequest;
import org.pdfsam.model.news.ToggleNewsPanelRequest;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.ui.ContentItem;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.model.ui.SetTitleRequest;
import org.pdfsam.model.ui.ShowLogMessagesRequest;
import org.tinylog.Logger;
import org.tinylog.Supplier;

@Auto
public class AppContentController {
    private final AppContainer container;
    private final Map<String, Item> items = new HashMap<String, Item>();
    private final VBox news;
    private final ApplicationContext context;

    @Inject
    public AppContentController(AppContainer container, NewsPanel news, List<ContentItem> itemsList) {
        this(container, news, itemsList, ApplicationContext.app());
    }

    AppContentController(AppContainer container, NewsPanel news, List<ContentItem> itemsList, ApplicationContext context) {
        this.container = container;
        this.context = context;
        this.news = new VBox(new Node[]{news});
        this.news.getStyleClass().add((Object)"news-panel-container");
        itemsList.stream().filter(i -> !i.disabled()).forEach(i -> this.items.put(i.id(), new Item(i.name(), (Supplier<Pane>)((Supplier)() -> ((ContentItem)i).panel()), null)));
        context.runtimeState().tools().values().forEach(t -> this.items.put(t.id(), new Item(t.descriptor().name(), (Supplier<Pane>)((Supplier)() -> ((Tool)t).panel()), (Tool)t)));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onSetActiveContentItem(SetActiveContentItemRequest request) {
        Logger.trace((String)"Set active content request to '{}'", (Object[])new Object[]{request.id()});
        Item item = this.items.get(request.id());
        if (Objects.nonNull(item)) {
            this.setActivePane((Pane)item.paneSupplier().get());
            StaticStudio.eventStudio().broadcast((Object)new SetTitleRequest(item.name()));
        }
        this.context.runtimeState().activeTool((Tool)Optional.ofNullable(item).map(Item::tool).orElse(null));
    }

    @EventListener
    public void onShowLogMessagesRequest(ShowLogMessagesRequest request) {
        Logger.trace((Object)"Set active content request to Log content");
        Item item = this.items.get("LOGS");
        if (Objects.nonNull(item)) {
            this.setActivePane((Pane)item.paneSupplier().get());
            StaticStudio.eventStudio().broadcast((Object)new SetTitleRequest(item.name()));
        }
    }

    @EventListener(priority=-2147483648)
    public void onShowNewsPanel(ToggleNewsPanelRequest request) {
        Optional.ofNullable(this.container.getRight()).ifPresentOrElse(d -> this.fadeOut((Node)this.news, (EventHandler<ActionEvent>)((EventHandler)a -> this.container.setRight(null))), this::fadeInNews);
    }

    @EventListener(priority=-2147483648)
    public void onHideNewsPanel(HideNewsPanelRequest request) {
        this.fadeOut((Node)this.news, (EventHandler<ActionEvent>)((EventHandler)a -> this.container.setRight(null)));
    }

    private void setActivePane(Pane panel) {
        if (Objects.nonNull(panel) && !panel.equals(this.container.getContent())) {
            this.fadeOut(this.container.getContent(), null);
            this.fadeIn(panel);
        }
    }

    private void fadeOut(Node node, EventHandler<ActionEvent> onFinish) {
        if (Objects.nonNull(node)) {
            FadeTransition fade = new FadeTransition(new Duration(150.0), node);
            fade.setFromValue(1.0);
            fade.setToValue(0.0);
            fade.play();
            if (Objects.nonNull(onFinish)) {
                fade.setOnFinished(onFinish);
            }
        }
    }

    private void fadeIn(Pane newNode) {
        FadeTransition fade = new FadeTransition(new Duration(150.0), (Node)newNode);
        fade.setFromValue(0.0);
        fade.setToValue(1.0);
        newNode.setOpacity(0.0);
        this.container.setContent(newNode);
        fade.play();
    }

    private void fadeInNews() {
        FadeTransition fade = new FadeTransition(new Duration(150.0), (Node)this.news);
        fade.setFromValue(0.0);
        fade.setToValue(1.0);
        this.news.setOpacity(0.0);
        this.container.setRight((Node)this.news);
        fade.play();
    }

    private record Item(String name, Supplier<Pane> paneSupplier, Tool tool) {
    }
}

