/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui;

import java.awt.SplashScreen;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.pdfsam.core.AppBrand;
import org.pdfsam.core.BrandableProperty;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.eventstudio.DefaultEventStudio;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.AppContainer;
import org.pdfsam.gui.ApplicationTitleController;
import org.pdfsam.gui.InputPdfArgumentsConsumer;
import org.pdfsam.gui.UncaughtExceptionLogger;
import org.pdfsam.gui.WindowStatusController;
import org.pdfsam.gui.components.content.preference.PreferenceConfig;
import org.pdfsam.gui.components.notification.NotificationsContainer;
import org.pdfsam.gui.configuration.PdfsamConfig;
import org.pdfsam.gui.configuration.PersistenceConfig;
import org.pdfsam.gui.configuration.ServicesConfig;
import org.pdfsam.gui.theme.Themes;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.i18n.SetLocaleRequest;
import org.pdfsam.injector.Injector;
import org.pdfsam.injector.Key;
import org.pdfsam.model.lifecycle.CleanupRequest;
import org.pdfsam.model.lifecycle.ShutdownEvent;
import org.pdfsam.model.lifecycle.StartupEvent;
import org.pdfsam.model.news.FetchLatestNewsRequest;
import org.pdfsam.model.premium.FetchPremiumModulesRequest;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.model.ui.SetLatestStageStatusRequest;
import org.pdfsam.model.ui.StageMode;
import org.pdfsam.model.ui.StageStatus;
import org.pdfsam.model.ui.workspace.LoadWorkspaceRequest;
import org.pdfsam.model.ui.workspace.SaveWorkspaceRequest;
import org.pdfsam.model.update.UpdateCheckRequest;
import org.pdfsam.ui.components.tool.RunButtonTriggerRequest;
import org.sejda.core.Sejda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfsamApp
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(PdfsamApp.class);
    private static final StopWatch STOPWATCH = new StopWatch();
    private Stage primaryStage;
    private List<String> rawParameters;
    private boolean clean;

    public void init() {
        STOPWATCH.start();
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
        this.rawParameters = this.getParameters().getRaw();
        System.setProperty("sejda.sambox.asyncwriter", Boolean.TRUE.toString());
        System.setProperty("sejda.unethical.read", Boolean.TRUE.toString());
        System.setProperty("sejda.tmp.buffer.prefix", "pdfsam");
        LOG.info("Starting...");
        boolean bl = this.clean = this.rawParameters.contains("--clean") || this.rawParameters.contains("-clean") || this.rawParameters.contains("-c");
        if (this.clean) {
            ApplicationContext.app().clean();
        }
        ApplicationContext.app().persistentSettings().get(StringPersistentProperty.LOCALE).ifPresent(l -> StaticStudio.eventStudio().broadcast((Object)new SetLocaleRequest(l)));
    }

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.initInjector(primaryStage);
        this.cleanIfRequired();
        primaryStage.setScene(this.initScene());
        primaryStage.getIcons().addAll((Collection)ApplicationContext.app().instance(Key.of(List.class, (String)"icons")));
        primaryStage.setOnCloseRequest(e -> Platform.exit());
        ((WindowStatusController)ApplicationContext.app().instance(WindowStatusController.class)).setStage(primaryStage);
        ((ApplicationTitleController)ApplicationContext.app().instance(ApplicationTitleController.class)).setStage(primaryStage);
        this.requestPremiumModulesDescriptionIfRequired();
        this.initStartupContentItem();
        this.loadWorkspaceIfRequired();
        this.escapeMnemonicsOnFocusLost();
        primaryStage.show();
        this.requestCheckForUpdateIfRequired();
        this.requestLatestNewsIfRequired();
        this.initSejda();
        this.closeSplash();
        STOPWATCH.stop();
        StaticStudio.eventStudio().broadcast((Object)new StartupEvent());
        LOG.info(I18nContext.i18n().tr("Started in {0}", new String[]{DurationFormatUtils.formatDurationWords((long)STOPWATCH.getTime(), (boolean)true, (boolean)true)}));
        new InputPdfArgumentsConsumer().accept(this.rawParameters);
    }

    private void initInjector(Stage primaryStage) {
        Injector.addConfig((Object[])new Object[]{new PdfsamConfig(this.getHostServices(), primaryStage)});
        Injector.addConfig((Object[])new Object[]{new PersistenceConfig(), new ServicesConfig(), new PreferenceConfig()});
        ApplicationContext.app().injector(Injector.start());
    }

    private void cleanIfRequired() {
        if (this.clean) {
            LOG.debug("Cleaning...");
            StaticStudio.eventStudio().broadcast((Object)new CleanupRequest());
        }
    }

    private void initSejda() {
        AppBrand appBrand = (AppBrand)ApplicationContext.app().instance(AppBrand.class);
        Sejda.CREATOR = appBrand.property(BrandableProperty.SHORT_NAME, "PDFsam Basic") + " v" + appBrand.property(BrandableProperty.VERSION, "UNKNOWN");
    }

    private void closeSplash() {
        Optional.ofNullable(SplashScreen.getSplashScreen()).ifPresent(SplashScreen::close);
    }

    private Scene initScene() {
        AppContainer appContainer = (AppContainer)((Object)ApplicationContext.app().instance(AppContainer.class));
        NotificationsContainer notifications = (NotificationsContainer)((Object)ApplicationContext.app().instance(NotificationsContainer.class));
        StackPane main = new StackPane();
        StackPane.setAlignment((Node)notifications, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setAlignment((Node)appContainer, (Pos)Pos.TOP_LEFT);
        main.getChildren().addAll((Object[])new Node[]{appContainer, notifications});
        Scene mainScene = new Scene((Parent)main);
        this.initTheme(mainScene);
        mainScene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), Platform::exit);
        mainScene.getAccelerators().put((Object)RunButtonTriggerRequest.KEY_CODE_COMBINATION, () -> StaticStudio.eventStudio().broadcast((Object)RunButtonTriggerRequest.INSTANCE));
        return mainScene;
    }

    private void initTheme(Scene scene) {
        ApplicationContext.app().registerScene(scene);
        String theme = ApplicationContext.app().persistentSettings().get(StringPersistentProperty.THEME).orElse(null);
        ApplicationContext.app().runtimeState().theme(Themes.getOrDefault(theme));
    }

    private void requestCheckForUpdateIfRequired() {
        if (ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.CHECK_UPDATES)) {
            StaticStudio.eventStudio().broadcast((Object)new UpdateCheckRequest(false));
        }
    }

    private void requestLatestNewsIfRequired() {
        if (ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.CHECK_FOR_NEWS)) {
            StaticStudio.eventStudio().broadcast((Object)FetchLatestNewsRequest.INSTANCE);
        }
    }

    private void escapeMnemonicsOnFocusLost() {
        this.primaryStage.focusedProperty().addListener((obs, oldVal, newVal) -> {
            if (!newVal.booleanValue()) {
                Event.fireEvent((EventTarget)this.primaryStage.getScene(), (Event)new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, KeyCode.ESCAPE.getName(), KeyCode.ESCAPE, false, false, false, false));
            }
        });
    }

    private void initStartupContentItem() {
        String contentItemId = ApplicationContext.app().persistentSettings().get(StringPersistentProperty.STARTUP_MODULE).filter(StringUtils::isNotBlank).orElse("TOOLS");
        LOG.trace("Activating startup content item '{}'", (Object)contentItemId);
        StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest(contentItemId));
    }

    private void requestPremiumModulesDescriptionIfRequired() {
        if (ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.PREMIUM_MODULES)) {
            StaticStudio.eventStudio().broadcast((Object)FetchPremiumModulesRequest.INSTANCE);
        }
    }

    private void loadWorkspaceIfRequired() {
        Optional.ofNullable((String)this.getParameters().getNamed().get("workspace")).filter(StringUtils::isNotBlank).or(() -> ApplicationContext.app().persistentSettings().get(StringPersistentProperty.WORKSPACE_PATH).filter(StringUtils::isNotBlank)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toFile).map(LoadWorkspaceRequest::new).ifPresent(arg_0 -> ((DefaultEventStudio)StaticStudio.eventStudio()).broadcast(arg_0));
    }

    public void stop() {
        LOG.info(I18nContext.i18n().tr("Closing PDFsam..."));
        StageStatus status = new StageStatus(this.primaryStage.getX(), this.primaryStage.getY(), this.primaryStage.getWidth(), this.primaryStage.getHeight(), StageMode.valueFor((Stage)this.primaryStage));
        StaticStudio.eventStudio().broadcast((Object)new SetLatestStageStatusRequest(status));
        this.saveWorkspaceIfRequired();
        StaticStudio.eventStudio().broadcast((Object)new ShutdownEvent());
        ApplicationContext.app().close();
    }

    private void saveWorkspaceIfRequired() {
        if (ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.SAVE_WORKSPACE_ON_EXIT)) {
            ApplicationContext.app().persistentSettings().get(StringPersistentProperty.WORKSPACE_PATH).filter(StringUtils::isNotBlank).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toFile).map(SaveWorkspaceRequest::new).ifPresent(arg_0 -> ((DefaultEventStudio)StaticStudio.eventStudio()).broadcast(arg_0));
        }
    }
}

