/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.about;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.apache.commons.io.FileUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.AppBrand;
import org.pdfsam.core.BrandableProperty;
import org.pdfsam.core.support.io.ObjectCollectionWriter;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.components.commons.UrlButton;
import org.pdfsam.ui.components.support.Style;
import org.sejda.core.Sejda;

public class AboutPane
extends HBox {
    @Inject
    public AboutPane(AppBrand appBrand) {
        this.getStyleClass().add((Object)"spaced-container");
        this.getStyleClass().add((Object)"about-panel");
        VBox left = new VBox(6.0);
        this.addSectionTitle(appBrand.property(BrandableProperty.NAME, "PDFsam Basic"), (Pane)left);
        left.getChildren().addAll((Object[])new Node[]{new Label(String.format("ver. %s", appBrand.property(BrandableProperty.VERSION)))});
        this.addHyperlink((Ikon)UniconsLine.COPYRIGHT, appBrand.property(BrandableProperty.VENDOR_URL), appBrand.property(BrandableProperty.COPYRIGHT), (Pane)left);
        this.addHyperlink((Ikon)UniconsLine.BALANCE_SCALE, appBrand.property(BrandableProperty.LICENSE_URL), appBrand.property(BrandableProperty.LICENSE_NAME), (Pane)left);
        this.addHyperlink((Ikon)UniconsLine.HOME, appBrand.property(BrandableProperty.HOME_URL), appBrand.property(BrandableProperty.HOME_LABEL), (Pane)left);
        this.addHyperlink((Ikon)UniconsLine.RSS, appBrand.property(BrandableProperty.FEED_URL), I18nContext.i18n().tr("Subscribe to the official news feed"), (Pane)left);
        this.addSectionTitle(I18nContext.i18n().tr("Environment"), (Pane)left);
        Label runtime = new Label(String.format("%s %s", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")));
        Label vendor = new Label(String.format(I18nContext.i18n().tr("Vendor: %s"), System.getProperty("java.vendor")));
        Label runtimePath = new Label(String.format(I18nContext.i18n().tr("Java runtime path: %s"), System.getProperty("java.home")));
        Label fx = new Label(String.format(I18nContext.i18n().tr("JavaFX runtime version: %s"), System.getProperty("javafx.runtime.version")));
        Label sejda = new Label(String.format(I18nContext.i18n().tr("PDF engine (Sejda SDK) version: %s"), Sejda.VERSION));
        Label memory = new Label(I18nContext.i18n().tr("Max memory {0}", new String[]{FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory())}));
        Button copyButton = new Button(I18nContext.i18n().tr("Copy to clipboard"));
        copyButton.setGraphic((Node)FontIcon.of((Ikon)UniconsLine.COPY));
        copyButton.getStyleClass().addAll((Object[])Style.BUTTON.css());
        copyButton.setId("copyEnvDetails");
        copyButton.setOnAction(a -> {
            ClipboardContent content = new ClipboardContent();
            ObjectCollectionWriter.writeContent(Arrays.asList(appBrand.property(BrandableProperty.NAME, "PDFsam Basic"), appBrand.property(BrandableProperty.VERSION), runtime.getText(), vendor.getText(), runtimePath.getText(), fx.getText(), memory.getText())).to(content);
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        left.getChildren().addAll((Object[])new Node[]{runtime, vendor, runtimePath, fx, sejda, memory, copyButton});
        VBox right = new VBox(6.0);
        this.addSectionTitle(I18nContext.i18n().tr("Support"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.BUG, appBrand.property(BrandableProperty.TRACKER_URL), I18nContext.i18n().tr("Bug and feature requests"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.QUESTION_CIRCLE, appBrand.property(BrandableProperty.SUPPORT_URL), I18nContext.i18n().tr("Support"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.BOOK, appBrand.property(BrandableProperty.DOCUMENTATION_URL), I18nContext.i18n().tr("Documentation"), (Pane)right);
        this.addSectionTitle(I18nContext.i18n().tr("Contribute"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.GITHUB, appBrand.property(BrandableProperty.SCM_URL), I18nContext.i18n().tr("Fork PDFsam on GitHub"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.LANGUAGE, appBrand.property(BrandableProperty.TRANSLATE_URL), I18nContext.i18n().tr("Translate"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.DOLLAR_ALT, appBrand.property(BrandableProperty.DONATE_URL), I18nContext.i18n().tr("Donate"), (Pane)right);
        this.addSectionTitle(I18nContext.i18n().tr("Social"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.TWITTER, appBrand.property(BrandableProperty.TWITTER_URL), I18nContext.i18n().tr("Follow us on Twitter"), (Pane)right);
        this.addHyperlink((Ikon)UniconsLine.FACEBOOK, appBrand.property(BrandableProperty.FACEBOOK_URL), I18nContext.i18n().tr("Like us on Facebook"), (Pane)right);
        this.getChildren().addAll((Object[])new Node[]{left, right});
    }

    private void addSectionTitle(String title, Pane pane) {
        Label label = new Label(title);
        label.getStyleClass().add((Object)"section-title");
        pane.getChildren().add((Object)label);
    }

    private void addHyperlink(Ikon icon, String url, String text, Pane pane) {
        UrlButton button = UrlButton.styledUrlButton((String)text, (String)url, (Ikon)icon);
        button.getStyleClass().setAll((Object[])new String[]{"pdfsam-hyperlink"});
        pane.getChildren().add((Object)button);
    }
}

