/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.home;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.content.home.PremiumToolTile;
import org.pdfsam.gui.components.content.home.ToolsHomeTile;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.premium.PremiumTool;
import org.pdfsam.model.premium.PremiumToolsResponse;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;

public class HomePane
extends VBox {
    @Inject
    public HomePane() {
        this(ApplicationContext.app().runtimeState().tools().values());
    }

    public HomePane(Collection<Tool> tools) {
        this.getStyleClass().addAll((Object[])new String[]{"spaced-container"});
        tools.stream().collect(Collectors.groupingBy(t -> t.descriptor().category())).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            Label toolCategory = new Label(((ToolCategory)entry.getKey()).getDescription());
            toolCategory.getStyleClass().add((Object)"modules-tile-title");
            this.getChildren().add((Object)toolCategory);
            FlowPane toolsPane = new FlowPane();
            toolsPane.getStyleClass().add((Object)"home-tools");
            ((List)entry.getValue()).stream().sorted(Comparator.comparing(t -> t.descriptor().name())).map(ToolsHomeTile::new).forEach(arg_0 -> toolsPane.getChildren().add(arg_0));
            this.getChildren().add((Object)toolsPane);
        });
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onPremiumModules(PremiumToolsResponse e) {
        if (!e.premiumTools().isEmpty()) {
            Label premiumTile = new Label(I18nContext.i18n().tr("Premium features"));
            premiumTile.getStyleClass().add((Object)"modules-tile-title");
            FlowPane permiumToolsPanel = new FlowPane();
            permiumToolsPanel.getStyleClass().add((Object)"home-tools");
            e.premiumTools().stream().sorted(Comparator.comparingInt(PremiumTool::id)).map(PremiumToolTile::new).forEach(arg_0 -> permiumToolsPanel.getChildren().add(arg_0));
            Platform.runLater(() -> this.getChildren().addAll((Object[])new Node[]{premiumTile, permiumToolsPanel}));
        }
    }
}

