/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.log;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Scanner;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.gui.components.content.log.ErrorLoggedEvent;
import org.pdfsam.gui.components.content.log.LogLevel;
import org.pdfsam.gui.components.content.log.LogMessage;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.writers.AbstractFormatPatternWriter;

public class BroadcastingWriter
extends AbstractFormatPatternWriter {
    public BroadcastingWriter() {
        this(Collections.emptyMap());
    }

    public BroadcastingWriter(Map<String, String> properties) {
        super(properties);
    }

    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        Collection logEntryValues = super.getRequiredLogEntryValues();
        logEntryValues.add(LogEntryValue.LEVEL);
        return logEntryValues;
    }

    public void write(LogEntry logEntry) {
        try (Scanner scanner = new Scanner(this.render(logEntry));){
            while (scanner.hasNextLine()) {
                StaticStudio.eventStudio().broadcast((Object)new LogMessage(scanner.nextLine(), LogLevel.toLogLevel(logEntry.getLevel())));
            }
        }
        if (logEntry.getLevel().ordinal() == Level.ERROR.ordinal()) {
            StaticStudio.eventStudio().broadcast((Object)new ErrorLoggedEvent());
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

