/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.news;

import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.model.io.NativeOpenUrlRequest;
import org.pdfsam.model.news.NewsData;
import org.pdfsam.ui.components.commons.UrlButton;
import org.pdfsam.ui.components.support.Style;

public class News
extends VBox {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    News(NewsData data) {
        this.getStyleClass().add((Object)"news-box");
        TextFlow flow = new TextFlow();
        if (data.important()) {
            FontIcon megaphone = FontIcon.of((Ikon)UniconsLine.MEGAPHONE);
            megaphone.getStyleClass().clear();
            megaphone.getStyleClass().add((Object)"news-box-title-important");
            flow.getChildren().addAll((Object[])new Node[]{megaphone, new Text(" ")});
        }
        Text titleText = new Text(data.title() + System.lineSeparator());
        titleText.setOnMouseClicked(e -> StaticStudio.eventStudio().broadcast((Object)new NativeOpenUrlRequest(data.link())));
        titleText.getStyleClass().add((Object)"news-box-title");
        Text contentText = new Text(data.content());
        contentText.setTextAlignment(TextAlignment.JUSTIFY);
        contentText.getStyleClass().add((Object)"news-content");
        flow.getChildren().addAll((Object[])new Node[]{titleText, contentText});
        flow.setTextAlignment(TextAlignment.JUSTIFY);
        Label labelDate = new Label(FORMATTER.format(data.date()), (Node)FontIcon.of((Ikon)UniconsLine.CLOCK));
        labelDate.setPrefWidth(2.147483647E9);
        HBox.setHgrow((Node)labelDate, (Priority)Priority.ALWAYS);
        HBox bottom = new HBox(new Node[]{labelDate});
        bottom.setAlignment(Pos.CENTER_LEFT);
        bottom.getStyleClass().add((Object)"news-box-footer");
        if (StringUtils.isNotBlank((CharSequence)data.link())) {
            UrlButton link = UrlButton.urlButton(null, (String)data.link(), (Ikon)UniconsLine.EXTERNAL_LINK_ALT, (String[])Style.NEWS_BUTTON.css());
            bottom.getChildren().add((Object)link);
        }
        this.getChildren().addAll((Object[])new Node[]{flow, bottom});
    }
}

