/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.dialog;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.dialog.CreateOutputDirectoryConfirmationDialog;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.ui.NonExistingOutputDirectoryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class CreateOutputDirectoryDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(CreateOutputDirectoryDialogController.class);
    private final Provider<CreateOutputDirectoryConfirmationDialog> dialog;

    @Inject
    public CreateOutputDirectoryDialogController(Provider<CreateOutputDirectoryConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void request(NonExistingOutputDirectoryEvent event) {
        try {
            if (((CreateOutputDirectoryConfirmationDialog)((Object)this.dialog.get())).response()) {
                Files.createDirectories(event.outputDirectory(), new FileAttribute[0]);
                LOG.debug("Created output directory {}", (Object)event.outputDirectory());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to create output directory", (Throwable)e);
        }
    }
}

