/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.dialog;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.ui.InputPdfArgumentsLoadRequest;
import org.pdfsam.model.ui.SetActiveContentItemRequest;
import org.pdfsam.ui.components.commons.HideOnEscapeHandler;
import org.pdfsam.ui.components.support.Style;

public class OpenWithDialog
extends Stage {
    private final Label messageTitle = new Label();
    private final HBox buttons = new HBox(5.0);
    private final ListView<String> filesList = new ListView();
    private final List<Tool> tools;

    @Inject
    public OpenWithDialog(@Named(value="primaryStage") Stage stage) {
        this(ApplicationContext.app().runtimeState().tools().values(), stage);
    }

    OpenWithDialog(Collection<Tool> tools, @Named(value="primaryStage") Stage stage) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initStyle(StageStyle.UTILITY);
        this.setTitle(I18nContext.i18n().tr("Open with"));
        this.initOwner((Window)stage);
        this.tools = tools.stream().sorted(Comparator.comparing(m -> m.descriptor().name())).collect(Collectors.toList());
        this.messageTitle.getStyleClass().add((Object)"-pdfsam-open-with-dialog-title");
        BorderPane containerPane = new BorderPane();
        containerPane.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.getStyleClass().addAll((Object[])new String[]{"-pdfsam-open-with-dialog", "-pdfsam-open-with-container"});
        containerPane.setTop((Node)this.messageTitle);
        BorderPane.setAlignment((Node)this.messageTitle, (Pos)Pos.TOP_CENTER);
        this.filesList.setPrefHeight(150.0);
        containerPane.setCenter(this.filesList);
        this.buttons.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.setBottom((Node)this.buttons);
        BorderPane.setAlignment((Node)this.buttons, (Pos)Pos.CENTER);
        Scene scene = new Scene((Parent)containerPane);
        scene.setOnKeyReleased((EventHandler)new HideOnEscapeHandler((Window)this));
        this.setScene(scene);
        ApplicationContext.app().registerScene(scene);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        Platform.runLater(() -> {
            scene.getWindow().sizeToScene();
            this.setResizable(false);
        });
        this.setOnShown(e -> this.requestFocus());
    }

    OpenWithDialog initFor(InputPdfArgumentsLoadRequest event) {
        this.messageTitle.setText(I18nContext.i18n().tr("Select the task to perform on the following files"));
        this.filesList.setItems(FXCollections.observableArrayList((Collection)event.pdfs().stream().map(Path::toString).collect(Collectors.toList())));
        this.tools.forEach(m -> {
            if (m.descriptor().hasInputType(event.requiredInputType())) {
                Button current = new Button(m.descriptor().name());
                current.getStyleClass().addAll((Object[])Style.FOOTER_BUTTON.css());
                Optional.ofNullable(m.graphic()).ifPresent(g -> {
                    g.setScaleX(0.7);
                    g.setScaleY(0.7);
                    current.setGraphic(g);
                });
                current.setOnAction(e -> {
                    StaticStudio.eventStudio().broadcast((Object)new ClearToolRequest(m.id(), false, false), m.id());
                    StaticStudio.eventStudio().broadcast((Object)new SetActiveContentItemRequest(m.id()));
                    this.hide();
                    PdfLoadRequest loadEvent = new PdfLoadRequest(m.id());
                    event.pdfs().stream().map(Path::toFile).map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequest)loadEvent).add(arg_0));
                    StaticStudio.eventStudio().broadcast((Object)loadEvent, m.id());
                });
                this.buttons.getChildren().add((Object)current);
            }
        });
        return this;
    }
}

