/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.gui.components.content.preference.PreferenceBrowsableDirectoryField;
import org.pdfsam.gui.components.content.preference.PreferenceBrowsableFileField;
import org.pdfsam.gui.components.content.preference.PreferenceCheckBox;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;
import org.pdfsam.ui.components.support.Views;

class PreferenceWorkspacePane
extends VBox {
    @Inject
    public PreferenceWorkspacePane(@Named(value="workingDirectory") PreferenceBrowsableDirectoryField workingDirectory, @Named(value="workspace") PreferenceBrowsableFileField workspace, @Named(value="saveWorkspaceOnExit") PreferenceCheckBox saveWorkspaceOnExit, @Named(value="savePwdInWorkspace") PreferenceCheckBox savePwdInWorkspace) {
        workingDirectory.getTextField().setPromptText(I18nContext.i18n().tr("Select a directory where documents will be saved and loaded by default"));
        workingDirectory.setBrowseWindowTitle(I18nContext.i18n().tr("Select a directory"));
        GridPane workigDirPane = new GridPane();
        workigDirPane.getStyleClass().addAll((Object[])Style.GRID.css());
        workigDirPane.getStyleClass().addAll((Object[])Style.VITEM.css());
        GridPane.setValignment((Node)workingDirectory, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)workingDirectory, (HPos)HPos.LEFT);
        GridPane.setHgrow((Node)workingDirectory, (Priority)Priority.ALWAYS);
        workigDirPane.add((Node)workingDirectory, 0, 0);
        Text workingDirLabel = Views.helpIcon((String)I18nContext.i18n().tr("Select a directory where documents will be saved and loaded by default"));
        GridPane.setValignment((Node)workingDirLabel, (VPos)VPos.CENTER);
        workigDirPane.add((Node)workingDirLabel, 1, 0);
        workspace.getTextField().setPromptText(I18nContext.i18n().tr("Select a previously saved workspace that will be automatically loaded at startup"));
        workspace.setBrowseWindowTitle(I18nContext.i18n().tr("Select a workspace"));
        GridPane workspaceDirPane = new GridPane();
        workspaceDirPane.getStyleClass().addAll((Object[])Style.GRID.css());
        workspaceDirPane.getStyleClass().addAll((Object[])Style.VITEM.css());
        GridPane.setValignment((Node)workspace, (VPos)VPos.BOTTOM);
        GridPane.setHalignment((Node)workspace, (HPos)HPos.LEFT);
        GridPane.setHgrow((Node)workspace, (Priority)Priority.ALWAYS);
        workspaceDirPane.add((Node)workspace, 0, 0);
        Text workspaceDirLabel = Views.helpIcon((String)I18nContext.i18n().tr("Select a previously saved workspace that will be automatically loaded at startup"));
        GridPane.setValignment((Node)workspaceDirLabel, (VPos)VPos.CENTER);
        workspaceDirPane.add((Node)workspaceDirLabel, 1, 0);
        workspace.getTextField().validProperty().addListener((o, oldVal, newVal) -> saveWorkspaceOnExit.setDisable(StringUtils.isBlank((CharSequence)workspace.getTextField().getText()) || newVal != FXValidationSupport.ValidationState.VALID));
        workspace.getTextField().validate();
        this.getChildren().addAll((Object[])new Node[]{new Label(I18nContext.i18n().tr("Default working directory:")), workigDirPane, new Label(I18nContext.i18n().tr("Load default workspace at startup:")), workspaceDirPane, saveWorkspaceOnExit, savePwdInWorkspace});
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
    }
}

