/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.dialog;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.gui.components.dialog.ConfirmationDialogContent;
import org.pdfsam.gui.components.dialog.DialogStyle;
import org.pdfsam.ui.components.support.Style;

public class ConfirmationDialog
extends Stage {
    private final ConfirmationDialogContent dialogContent;
    private boolean response = false;

    public ConfirmationDialog(DialogStyle style, Stage owner, String positiveButtonText, String negativeButtonText) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initStyle(StageStyle.UTILITY);
        this.initOwner((Window)owner);
        this.dialogContent = new ConfirmationDialogContent(style.icon);
        VBox containerPane = new VBox();
        containerPane.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        containerPane.getStyleClass().addAll((Object[])new String[]{"-pdfsam-dialog", style.style});
        HBox buttons = new HBox(new Node[]{this.buildPositiveButton(positiveButtonText, true), this.buildCancelButton(negativeButtonText, false)});
        buttons.getStyleClass().add((Object)"-pdfsam-dialog-buttons");
        containerPane.getChildren().addAll((Object[])new Node[]{this.dialogContent, buttons});
        Scene scene = new Scene((Parent)containerPane);
        this.setScene(scene);
        ApplicationContext.app().registerScene(scene);
        Platform.runLater(() -> {
            scene.getWindow().sizeToScene();
            this.setResizable(false);
        });
        this.setOnShown(e -> this.requestFocus());
    }

    ConfirmationDialog title(String title) {
        this.setTitle(title);
        return this;
    }

    ConfirmationDialog messageTitle(String title) {
        this.dialogContent.messageTitle(title);
        return this;
    }

    ConfirmationDialog messageContent(String title) {
        this.dialogContent.messageContent(title);
        return this;
    }

    public boolean response() {
        this.showAndWait();
        return this.response;
    }

    private Button buildButton(String text, boolean response) {
        Button button = new Button(text);
        button.getStyleClass().addAll((Object[])Style.BUTTON.css());
        button.setOnAction(e -> {
            this.response = response;
            this.hide();
        });
        return button;
    }

    private Button buildPositiveButton(String text, boolean response) {
        Button button = this.buildButton(text, response);
        button.setDefaultButton(true);
        return button;
    }

    private Button buildCancelButton(String text, boolean response) {
        Button button = this.buildButton(text, response);
        button.setCancelButton(true);
        return button;
    }
}

