/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.dialog;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.exception.BroadcastInterruptionException;
import org.pdfsam.gui.components.dialog.OverwriteConfirmationDialog;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.FileOrDirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.base.AbstractParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class OverwriteDialogController {
    private static final Logger LOG = LoggerFactory.getLogger(OverwriteDialogController.class);
    private final Provider<OverwriteConfirmationDialog> dialog;

    @Inject
    public OverwriteDialogController(Provider<OverwriteConfirmationDialog> dialog) {
        this.dialog = dialog;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener(priority=-2147483648)
    public void request(TaskExecutionRequest event) {
        final AbstractParameters params = event.parameters();
        try {
            if (params.getExistingOutputPolicy() != ExistingOutputPolicy.OVERWRITE) {
                event.parameters().getOutput().accept(new TaskOutputDispatcher(){

                    public void dispatch(FileOrDirectoryTaskOutput output) {
                        OverwriteDialogController.this.onDirectory(params, output.getDestination());
                    }

                    public void dispatch(DirectoryTaskOutput output) {
                        OverwriteDialogController.this.onDirectory(params, output.getDestination());
                    }

                    public void dispatch(FileTaskOutput output) {
                        OverwriteDialogController.this.onFile(params, output.getDestination());
                    }
                });
            }
        }
        catch (TaskOutputVisitException e) {
            LOG.warn("Unable to show overwrite confirmation dialog", (Throwable)e);
        }
    }

    private void onDirectory(AbstractParameters params, File dir) {
        if (ArrayUtils.isNotEmpty((Object[])dir.listFiles())) {
            OverwriteConfirmationDialog dlg = ((OverwriteConfirmationDialog)((Object)this.dialog.get())).init();
            ExistingOutputPolicy response = dlg.title(I18nContext.i18n().tr("Directory not empty")).messageTitle(I18nContext.i18n().tr("The selected directory is not empty")).messageContent(I18nContext.i18n().tr("What would you like to do in case of files with the same name?")).buttons(dlg.defaultButton(I18nContext.i18n().tr("Overwrite"), ExistingOutputPolicy.OVERWRITE), dlg.button(I18nContext.i18n().tr("Rename"), ExistingOutputPolicy.RENAME), dlg.button(I18nContext.i18n().tr("Skip"), ExistingOutputPolicy.SKIP), dlg.cancelButton(I18nContext.i18n().tr("Cancel"))).response().orElseThrow(() -> new BroadcastInterruptionException(I18nContext.i18n().tr("Don't overwrite existing file")));
            LOG.trace("Setting existing output policy to {}", (Object)response);
            params.setExistingOutputPolicy(response);
        }
    }

    private void onFile(AbstractParameters params, File file) {
        if (file.exists()) {
            OverwriteConfirmationDialog dlg = ((OverwriteConfirmationDialog)((Object)this.dialog.get())).init();
            ExistingOutputPolicy response = dlg.title(I18nContext.i18n().tr("Overwrite confirmation")).messageTitle(I18nContext.i18n().tr("A file with the given name already exists")).messageContent(I18nContext.i18n().tr("What would you like to do?")).buttons(dlg.defaultButton(I18nContext.i18n().tr("Overwrite"), ExistingOutputPolicy.OVERWRITE), dlg.button(I18nContext.i18n().tr("Rename"), ExistingOutputPolicy.RENAME), dlg.cancelButton(I18nContext.i18n().tr("Cancel"))).response().orElseThrow(() -> new BroadcastInterruptionException(I18nContext.i18n().tr("Don't overwrite existing file")));
            LOG.trace("Setting existing output policy to {}", (Object)response);
            params.setExistingOutputPolicy(response);
        }
    }
}

