/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.configuration;

import jakarta.inject.Named;
import javafx.application.HostServices;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import org.pdfsam.gui.AppContentController;
import org.pdfsam.gui.RunAcceleratorController;
import org.pdfsam.gui.WindowStatusController;
import org.pdfsam.gui.components.content.about.AboutContentItem;
import org.pdfsam.gui.components.content.home.HomeContentItem;
import org.pdfsam.gui.components.content.log.LogContentItem;
import org.pdfsam.gui.components.content.preference.PreferenceContentItem;
import org.pdfsam.gui.components.dialog.ClearToolConfirmationDialogController;
import org.pdfsam.gui.components.dialog.CreateOutputDirectoryDialogController;
import org.pdfsam.gui.components.dialog.LenientTaskExecutionDialogController;
import org.pdfsam.gui.components.dialog.OpenWithDialogController;
import org.pdfsam.gui.components.dialog.OverwriteDialogController;
import org.pdfsam.gui.components.dnd.FilesDropController;
import org.pdfsam.gui.components.info.InfoStageController;
import org.pdfsam.gui.components.notification.NotificationsController;
import org.pdfsam.gui.io.NativeOpenFileController;
import org.pdfsam.gui.io.NativeOpenUrlController;
import org.pdfsam.gui.sound.PlaySoundController;
import org.pdfsam.injector.Components;
import org.pdfsam.injector.Prototype;
import org.pdfsam.injector.Provides;

@Components(value={NativeOpenFileController.class, NativeOpenUrlController.class, WindowStatusController.class, PlaySoundController.class, NotificationsController.class, InfoStageController.class, OpenWithDialogController.class, OverwriteDialogController.class, CreateOutputDirectoryDialogController.class, ClearToolConfirmationDialogController.class, LenientTaskExecutionDialogController.class, FilesDropController.class, AppContentController.class, RunAcceleratorController.class, AboutContentItem.class, PreferenceContentItem.class, HomeContentItem.class, LogContentItem.class})
public class PdfsamConfig {
    private final HostServices services;
    private final Stage primaryStage;

    public PdfsamConfig(HostServices services, Stage primaryStage) {
        this.services = services;
        this.primaryStage = primaryStage;
    }

    @Provides
    @Named(value="primaryStage")
    public Stage primaryStage() {
        return this.primaryStage;
    }

    @Provides
    public HostServices hostServices() {
        return this.services;
    }

    @Provides
    @Named(value="errorSound")
    public String error() {
        return this.getClass().getResource("/org/pdfsam/gui/sounds/error_sound.wav").toExternalForm();
    }

    @Provides
    @Named(value="okSound")
    public String ok() {
        return this.getClass().getResource("/org/pdfsam/gui/sounds/ok_sound.wav").toExternalForm();
    }

    @Provides
    @Prototype
    public ImageView payoff() {
        return new ImageView(this.getClass().getResource("/org/pdfsam/gui/images/logo.png").toExternalForm());
    }
}

