/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.pdf;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.lifecycle.ShutdownEvent;
import org.pdfsam.model.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.pdf.PdfFilesListLoadRequest;
import org.pdfsam.model.pdf.PdfLoadRequest;
import org.pdfsam.model.tool.RequiredPdfData;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.service.pdf.PdfListParser;
import org.pdfsam.service.pdf.PdfLoadService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class PdfLoadController {
    private static final Logger LOG = LoggerFactory.getLogger(PdfLoadController.class);
    private final PdfLoadService loadService;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Map<String, RequiredPdfData[]> requiredLoadData = new HashMap<String, RequiredPdfData[]>();

    @Inject
    public PdfLoadController(PdfLoadService loadService) {
        this(ApplicationContext.app().runtimeState().tools().values(), loadService);
    }

    PdfLoadController(Collection<Tool> tools, PdfLoadService loadService) {
        this.loadService = loadService;
        tools.forEach(m -> this.requiredLoadData.put(m.id(), m.requires()));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void request(PdfLoadRequest event) {
        LOG.trace("PDF load request received");
        event.getDocuments().forEach(i -> i.moveStatusTo(PdfDescriptorLoadingStatus.REQUESTED));
        this.executor.execute(() -> this.loadService.load(event.getDocuments(), this.requiredLoadData.get(event.toolBinding())));
    }

    @EventListener
    public void request(PdfFilesListLoadRequest event) {
        LOG.trace("PDF load from list request received");
        if (Objects.nonNull(event.list)) {
            this.executor.execute(() -> {
                try {
                    PdfLoadRequest loadEvent = new PdfLoadRequest(event.toolBinding());
                    new PdfListParser().apply(event.list).stream().map(PdfDocumentDescriptor::newDescriptorNoPassword).forEach(arg_0 -> ((PdfLoadRequest)loadEvent).add(arg_0));
                    if (loadEvent.getDocuments().isEmpty()) {
                        LOG.error(I18nContext.i18n().tr("Unable to find any valid PDF file in the list: {0}", new String[]{event.list.toString()}));
                    } else {
                        StaticStudio.eventStudio().broadcast((Object)loadEvent, event.toolBinding());
                    }
                }
                catch (Exception e) {
                    LOG.error(I18nContext.i18n().tr("Unable to load PDF list file from {0}", new String[]{event.list.toString()}), (Throwable)e);
                }
            });
        }
    }

    @EventListener
    public void onShutdown(ShutdownEvent event) {
        this.executor.shutdownNow();
    }
}

