/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.task;

import jakarta.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.lifecycle.ShutdownEvent;
import org.pdfsam.model.tool.TaskExecutionRequest;
import org.pdfsam.service.tool.UsageService;
import org.sejda.core.notification.context.GlobalNotificationContext;
import org.sejda.core.service.TaskExecutionService;
import org.sejda.model.notification.EventListener;
import org.sejda.model.notification.event.AbstractNotificationEvent;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.sejda.model.notification.event.TaskExecutionStartedEvent;
import org.sejda.model.parameter.base.TaskParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class TaskExecutionController {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutionController.class);
    private final TaskExecutionService executionService;
    private final UsageService usageService;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private String currentModule = "";

    @Inject
    public TaskExecutionController(TaskExecutionService executionService, UsageService usageService) {
        this.executionService = executionService;
        this.usageService = usageService;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        GlobalNotificationContext.getContext().addListener(TaskExecutionFailedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(TaskExecutionStartedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(TaskExecutionCompletedEvent.class, e -> {
            e.getNotifiableTaskMetadata().skippedOutput().forEach(f -> LOG.warn(I18nContext.i18n().tr("The following file already existed and was skipped: {0}", new String[]{f.getName()})));
            new TaskEventBroadcaster<TaskExecutionCompletedEvent>().onEvent((TaskExecutionCompletedEvent)e);
        });
        GlobalNotificationContext.getContext().addListener(PercentageOfWorkDoneChangedEvent.class, new TaskEventBroadcaster());
    }

    @org.pdfsam.eventstudio.annotation.EventListener(priority=0x7FFFFFFF)
    public void request(TaskExecutionRequest event) {
        LOG.trace("Task execution request received");
        this.usageService.incrementUsageFor(event.toolId());
        this.currentModule = event.toolId();
        this.executor.execute(() -> this.executionService.execute((TaskParameters)event.parameters()));
        LOG.trace("Task execution submitted");
    }

    @org.pdfsam.eventstudio.annotation.EventListener
    public void onShutdown(ShutdownEvent event) {
        this.executor.shutdownNow();
    }

    class TaskEventBroadcaster<T extends AbstractNotificationEvent>
    implements EventListener<T> {
        TaskEventBroadcaster() {
        }

        public void onEvent(T event) {
            Platform.runLater(() -> StaticStudio.eventStudio().broadcast(event));
            if (StringUtils.isNotBlank((CharSequence)TaskExecutionController.this.currentModule)) {
                Platform.runLater(() -> StaticStudio.eventStudio().broadcast((Object)event, TaskExecutionController.this.currentModule));
            }
        }
    }
}

