/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.tool;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.pdfsam.persistence.DefaultEntityRepository;
import org.pdfsam.persistence.PersistenceException;
import org.pdfsam.service.tool.ToolUsage;
import org.pdfsam.service.tool.UsageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUsageService
implements UsageService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUsageService.class);
    static final String TOOL_USAGE_KEY = "module.usage";
    static final String TASKS_EXECUTED_KEY = "tasks.executed";
    private final DefaultEntityRepository<ToolUsage> repo;

    @Inject
    DefaultUsageService(@Named(value="usageRepository") DefaultEntityRepository<ToolUsage> repo) {
        this.repo = repo;
    }

    @Override
    public void incrementUsageFor(String moduleId) {
        try {
            ToolUsage usage = ((ToolUsage)this.repo.get(TOOL_USAGE_KEY, (Object)new ToolUsage(moduleId))).inc();
            this.repo.save(TOOL_USAGE_KEY, (Object)usage);
            LOG.trace("Usage incremented for tool {}", (Object)moduleId);
        }
        catch (PersistenceException e) {
            LOG.error("Unable to increment tools usage statistics", (Throwable)e);
        }
        finally {
            this.incrementTotalUsage();
        }
    }

    @Override
    public void clear() {
        try {
            this.repo.clean();
        }
        catch (PersistenceException e) {
            LOG.error("Unable to clear latest news store", (Throwable)e);
        }
    }

    @Override
    public long getTotalUsages() {
        return this.repo.getLong(TASKS_EXECUTED_KEY, 0L);
    }

    private void incrementTotalUsage() {
        this.repo.saveLong(TASKS_EXECUTED_KEY, this.repo.getLong(TASKS_EXECUTED_KEY, 0L) + 1L);
    }
}

