/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.service.ui.WorkspaceService;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkspaceService
implements WorkspaceService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWorkspaceService.class);
    private final ObjectMapper objectMapper;

    @Inject
    public DefaultWorkspaceService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void saveWorkspace(Map<String, Map<String, String>> data, File destination) {
        RequireUtils.requireNotNullArg((Object)destination, (String)"Destination file cannot be null");
        LOG.debug(I18nContext.i18n().tr("Saving workspace data to {0}", new String[]{destination.getAbsolutePath()}));
        try {
            this.objectMapper.writeValue(destination, data);
            LOG.info(I18nContext.i18n().tr("Workspace saved"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Map<String, String>> loadWorkspace(File workspace) {
        RequireUtils.requireNotNullArg((Object)workspace, (String)"Workspace file cannot be null");
        try {
            return Optional.ofNullable((Map)this.objectMapper.readValue(workspace, Map.class)).orElseGet(Collections::emptyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

