/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.ui;

import jakarta.inject.Inject;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.lifecycle.CleanupRequest;
import org.pdfsam.model.ui.SetLatestStageStatusRequest;
import org.pdfsam.service.ui.StageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class StageServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(StageServiceController.class);
    private final StageService service;

    @Inject
    public StageServiceController(StageService service) {
        this.service = service;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void requestStageStatus(SetLatestStageStatusRequest event) {
        LOG.debug("Setting latest stage status to: {}", (Object)event.status());
        this.service.save(event.status());
    }

    @EventListener
    public void onCleanupRequest(CleanupRequest req) {
        this.service.clear();
    }
}

