/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.update;

import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.AppBrand;
import org.pdfsam.core.BrandableProperty;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.update.NoUpdateAvailable;
import org.pdfsam.model.update.UpdateAvailableEvent;
import org.pdfsam.model.update.UpdateCheckRequest;
import org.pdfsam.service.update.UpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class UpdatesController {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatesController.class);
    private final AppBrand appBrand;
    private final UpdateService service;

    @Inject
    UpdatesController(UpdateService service, AppBrand appBrand) {
        this.service = service;
        this.appBrand = appBrand;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void checkForUpdates(UpdateCheckRequest event) {
        Thread.ofVirtual().name("updates-checker-thread").start(() -> {
            LOG.debug(I18nContext.i18n().tr("Checking for updates"));
            try {
                String currentVersion = this.service.getLatestVersion();
                if (StringUtils.isNotBlank((CharSequence)currentVersion)) {
                    if (!this.appBrand.property(BrandableProperty.VERSION).equals(currentVersion)) {
                        LOG.info(I18nContext.i18n().tr("PDFsam {0} is available for download", new String[]{currentVersion}));
                        StaticStudio.eventStudio().broadcast((Object)new UpdateAvailableEvent(currentVersion));
                    } else if (event.notifyIfNoUpdates()) {
                        StaticStudio.eventStudio().broadcast((Object)new NoUpdateAvailable());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn(I18nContext.i18n().tr("Unable to find the latest available version."), (Throwable)e);
            }
        });
    }
}

