/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.splitbysize;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.core.support.validation.Validators;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.ui.ResettableView;
import org.pdfsam.model.ui.workspace.RestorableView;
import org.pdfsam.tools.splitbysize.SizeUnit;
import org.pdfsam.tools.splitbysize.SizeUnitRadio;
import org.pdfsam.tools.splitbysize.SplitBySizeParametersBuilder;
import org.pdfsam.ui.components.commons.ValidableTextField;
import org.pdfsam.ui.components.support.FXValidationSupport;
import org.pdfsam.ui.components.support.Style;

class SplitOptionsPane
extends HBox
implements TaskParametersBuildStep<SplitBySizeParametersBuilder>,
RestorableView,
ResettableView {
    private final ValidableTextField field = new ValidableTextField();
    private final ToggleGroup group = new ToggleGroup();

    SplitOptionsPane() {
        this.field.setOnEnterValidation(true);
        this.field.setEnableInvalidStyle(true);
        this.field.setPromptText(I18nContext.i18n().tr("Set the size to split at"));
        this.field.setValidator(Validators.positiveInteger());
        this.field.setErrorMessage(I18nContext.i18n().tr("Size must be a number"));
        this.field.setId("sizeField");
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{new Label(I18nContext.i18n().tr("Split at this size:")), this.field});
        Arrays.stream(SizeUnit.values()).map(SizeUnitRadio::new).forEach(r -> {
            r.setToggleGroup(this.group);
            this.getChildren().add((Object)r);
        });
        this.group.getToggles().stream().findFirst().ifPresent(t -> t.setSelected(true));
    }

    public void apply(SplitBySizeParametersBuilder builder, Consumer<String> onError) {
        this.field.validate();
        if (this.field.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            builder.size(((SizeUnitRadio)this.group.getSelectedToggle()).unit().toBytes(Integer.parseInt(this.field.getText())));
        } else {
            onError.accept(I18nContext.i18n().tr("Invalid split size"));
        }
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("size", StringUtils.defaultString((String)this.field.getText()));
        this.group.getToggles().stream().map(t -> (SizeUnitRadio)((Object)t)).forEach(s -> s.saveStateTo(data));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.field.setText(Optional.ofNullable(data.get("size")).orElse(""));
        this.group.getToggles().stream().map(t -> (SizeUnitRadio)((Object)t)).forEach(s -> s.restoreStateFrom(data));
    }

    public void resetView() {
        this.field.clear();
        this.group.getToggles().stream().findFirst().ifPresent(t -> t.setSelected(true));
    }
}

