/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import java.util.HashMap;
import java.util.Map;
import org.jnbt.Tag;

public final class CompoundTag
extends Tag {
    private Map<String, Tag> value;
    private static final long serialVersionUID = 1L;

    public CompoundTag(String name, Map<String, Tag> value) {
        super(name);
        this.value = new HashMap<String, Tag>(value);
    }

    public Map<String, Tag> getValue() {
        return this.value;
    }

    public boolean containsTag(String name) {
        return this.value.containsKey(name);
    }

    public Tag getTag(String name) {
        return this.value.get(name);
    }

    public void setTag(String name, Tag tag) {
        if (tag != null) {
            this.value.put(name, tag);
        } else {
            this.value.remove(name);
        }
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_Compound").append(append).append(": ").append(this.value.size()).append(" entries\r\n{\r\n");
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            bldr.append("   \"").append(entry.getKey()).append("\": ").append(entry.getValue().toString().replaceAll("\r\n", "\r\n   ")).append("\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }

    @Override
    public CompoundTag clone() {
        CompoundTag clone = (CompoundTag)super.clone();
        clone.value = new HashMap<String, Tag>();
        for (Map.Entry<String, Tag> entry : this.value.entrySet()) {
            clone.value.put(entry.getKey(), entry.getValue().clone());
        }
        return clone;
    }
}

