/*
 * Decompiled with CFR 0.152.
 */
package org.jnbt;

import org.jnbt.Tag;

public final class LongArrayTag
extends Tag {
    private long[] value;
    private static final long serialVersionUID = 1L;

    public LongArrayTag(String name, long[] value) {
        super(name);
        this.value = value;
    }

    public long[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        if (this.value.length <= 4) {
            for (long l : this.value) {
                String hexDigits = Long.toHexString(l).toUpperCase();
                hex.append("000000000000000", 0, 16 - hexDigits.length());
                hex.append(hexDigits).append(" ");
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                if (i != 2) {
                    String hexDigits = Long.toHexString(this.value[i <= 2 ? i : this.value.length - 1]).toUpperCase();
                    hex.append("000000000000000", 0, 16 - hexDigits.length());
                    hex.append(hexDigits).append(" ");
                    continue;
                }
                hex.append("(");
                hex.append(this.value.length - 3);
                hex.append(" more) ");
            }
        }
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Long_Array" + append + ": " + (hex.length() > 0 ? hex.substring(0, hex.length() - 1) : "empty");
    }

    @Override
    public LongArrayTag clone() {
        LongArrayTag clone = (LongArrayTag)super.clone();
        clone.value = (long[])this.value.clone();
        return clone;
    }
}

