/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Window;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;

public class TaskbarProgressReceiver
implements ProgressReceiver {
    private final Window window;
    private final ProgressReceiver nestedReceiver;
    private volatile boolean done;

    public TaskbarProgressReceiver(Window window, ProgressReceiver nestedReceiver) {
        this.window = window;
        this.nestedReceiver = nestedReceiver;
    }

    public void setProgress(float progress) throws ProgressReceiver.OperationCancelled {
        if (!this.done) {
            DesktopUtils.setProgress(this.window, Math.round(progress * 100.0f));
            if (progress >= 1.0f) {
                this.done = true;
            }
        }
        this.nestedReceiver.setProgress(progress);
    }

    public void exceptionThrown(Throwable exception) {
        if (!this.done) {
            DesktopUtils.setProgressError(this.window);
            this.done = true;
        }
        this.nestedReceiver.exceptionThrown(exception);
    }

    public void done() {
        DesktopUtils.setProgressDone(this.window);
        this.done = true;
        this.nestedReceiver.done();
    }

    public void setMessage(String message) throws ProgressReceiver.OperationCancelled {
        this.nestedReceiver.setMessage(message);
    }

    public void checkForCancellation() throws ProgressReceiver.OperationCancelled {
        this.nestedReceiver.checkForCancellation();
    }

    public void reset() throws ProgressReceiver.OperationCancelled {
        this.done = false;
        DesktopUtils.setProgress(this.window, 0);
        this.nestedReceiver.reset();
    }

    public void subProgressStarted(SubProgressReceiver subProgressReceiver) throws ProgressReceiver.OperationCancelled {
        this.nestedReceiver.subProgressStarted(subProgressReceiver);
    }
}

