/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.swing;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

final class ProgressViewer
extends JPanel
implements ProgressReceiver {
    private JLabel jLabel1;
    private JProgressBar jProgressBar1;
    private final SubProgressReceiver subProgressReceiver;
    private static final long serialVersionUID = 1L;

    ProgressViewer(SubProgressReceiver subProgressReceiver) {
        this.subProgressReceiver = subProgressReceiver;
        this.initComponents();
        subProgressReceiver.addListener((ProgressReceiver)this);
        String lastMessage = subProgressReceiver.getLastMessage();
        if (lastMessage != null) {
            try {
                this.setMessage(lastMessage);
            }
            catch (ProgressReceiver.OperationCancelled operationCancelled) {
                throw new MDCCapturingRuntimeException("Operation cancelled");
            }
        }
    }

    ProgressViewer() {
        this.subProgressReceiver = null;
        this.initComponents();
    }

    SubProgressReceiver getSubProgressReceiver() {
        return this.subProgressReceiver;
    }

    public void setProgress(float progress) {
        AwtUtils.doOnEventThreadAndWait(() -> {
            if (this.jProgressBar1.isIndeterminate()) {
                this.jProgressBar1.setIndeterminate(false);
            }
            this.jProgressBar1.setValue(Math.round(progress * 100.0f));
        });
    }

    public void exceptionThrown(Throwable exception) {
        AwtUtils.doOnEventThreadAndWait(() -> {
            if (this.jProgressBar1.isIndeterminate()) {
                this.jProgressBar1.setIndeterminate(false);
            }
        });
    }

    public void done() {
        AwtUtils.doOnEventThreadAndWait(() -> {
            if (this.jProgressBar1.isIndeterminate()) {
                this.jProgressBar1.setIndeterminate(false);
            }
            this.jProgressBar1.setValue(100);
        });
    }

    public void setMessage(String message) throws ProgressReceiver.OperationCancelled {
        AwtUtils.doOnEventThreadAndWait(() -> this.jLabel1.setText(message));
    }

    public void checkForCancellation() {
    }

    public void reset() {
        AwtUtils.doOnEventThreadAndWait(() -> this.jProgressBar1.setIndeterminate(true));
    }

    public void subProgressStarted(SubProgressReceiver subProgressReceiver) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1.setText(" ");
        this.jProgressBar1.setIndeterminate(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, -1, 318, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2).addContainerGap()));
    }
}

