/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

@NonNls
public final class IconUtils {
    private static volatile String theme;

    private IconUtils() {
    }

    public static String getTheme() {
        return theme;
    }

    public static void setTheme(String theme) {
        IconUtils.theme = theme;
    }

    public static ImageIcon loadUnscaledIcon(String path) {
        BufferedImage image = IconUtils.loadUnscaledImage(path);
        return image != null ? new ImageIcon(image) : null;
    }

    public static ImageIcon loadScaledIcon(String path) {
        BufferedImage image = IconUtils.loadScaledImage(path);
        return image != null ? new ImageIcon(image) : null;
    }

    public static ImageIcon loadScaledIcon(ClassLoader classLoader, String path) {
        BufferedImage image = IconUtils.loadScaledImage(classLoader, path);
        return image != null ? new ImageIcon(image) : null;
    }

    public static BufferedImage loadUnscaledImage(String path) {
        try {
            String themedPath;
            URL url;
            String string = path = path.startsWith("/") ? path.substring(1) : path;
            if (theme != null && (url = ClassLoader.getSystemResource(themedPath = path.substring(0, path.lastIndexOf(46)) + '_' + theme + path.substring(path.lastIndexOf(46)))) != null) {
                return ImageIO.read(url);
            }
            URL url2 = ClassLoader.getSystemResource(path);
            if (url2 != null) {
                return ImageIO.read(url2);
            }
            return null;
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error loading image " + path, (Throwable)e);
        }
    }

    public static BufferedImage loadScaledImage(String path) {
        BufferedImage image = IconUtils.loadUnscaledImage(path);
        if (image != null) {
            return GUIUtils.scaleToUI(image, true);
        }
        return null;
    }

    public static BufferedImage loadScaledImage(ClassLoader classLoader, String path) {
        try {
            String themedPath;
            URL url;
            if (theme != null && (url = classLoader.getResource(themedPath = path.substring(0, path.lastIndexOf(46)) + '_' + theme + path.substring(path.lastIndexOf(46)))) != null) {
                return GUIUtils.scaleToUI(ImageIO.read(url), true);
            }
            URL url2 = classLoader.getResource(path);
            if (url2 != null) {
                return GUIUtils.scaleToUI(ImageIO.read(url2), true);
            }
            return null;
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error loading image " + path, (Throwable)e);
        }
    }

    public static Icon createScaledColourIcon(int colour) {
        int size = Math.round(16.0f * GUIUtils.getUIScale());
        BufferedImage image = IconUtils.newBufferedImage(size);
        for (int x = 1; x < size - 1; ++x) {
            for (int y = 1; y < size - 1; ++y) {
                image.setRGB(x, y, 0xFF000000 | colour);
            }
        }
        return new ImageIcon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon createScaledLetterIcon(char letter, Color colour) {
        int size = Math.round(16.0f * GUIUtils.getUIScale());
        BufferedImage image = IconUtils.newBufferedImage(size);
        Graphics2D g2 = image.createGraphics();
        try {
            g2.setFont(Font.decode("SansSerif-BOLD").deriveFont(16.0f * GUIUtils.getUIScale()));
            g2.setColor(colour);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawString(String.valueOf(letter), Math.round(1.0f + 2.0f * GUIUtils.getUIScale()), Math.round((float)(size - 1) - 2.0f * GUIUtils.getUIScale()));
        }
        finally {
            g2.dispose();
        }
        return new ImageIcon(image);
    }

    public static ImageIcon scaleIcon(ImageIcon icon, int size) {
        return icon != null ? new ImageIcon(IconUtils.scaleIcon(icon.getImage(), size)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage scaleIcon(Image iconImage, int size) {
        int scaledSize = Math.round((float)size * GUIUtils.getUIScale());
        if (iconImage instanceof BufferedImage && ((BufferedImage)iconImage).getWidth() == scaledSize) {
            return (BufferedImage)iconImage;
        }
        BufferedImage newImage = IconUtils.newBufferedImage(scaledSize);
        Graphics2D g2 = newImage.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(iconImage, 0, 0, scaledSize, scaledSize, null);
        }
        finally {
            g2.dispose();
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon rotateIcon(Icon icon, int degrees) {
        BufferedImage bufferedImage;
        if (degrees == 0) {
            return icon;
        }
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                bufferedImage = IconUtils.newBufferedImage(image.getWidth(null));
                Graphics2D g2 = bufferedImage.createGraphics();
                try {
                    g2.drawImage(image, 0, 0, null);
                }
                finally {
                    g2.dispose();
                }
            }
        } else {
            bufferedImage = IconUtils.newBufferedImage(icon.getIconWidth());
            Graphics2D g2 = bufferedImage.createGraphics();
            try {
                icon.paintIcon(null, g2, 0, 0);
            }
            finally {
                g2.dispose();
            }
        }
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getRotateInstance(Math.toRadians(degrees), (double)icon.getIconWidth() / 2.0, (double)icon.getIconHeight() / 2.0), 3);
        BufferedImage targetImage = IconUtils.newBufferedImage(icon.getIconWidth());
        return new ImageIcon(op.filter(bufferedImage, targetImage));
    }

    private static BufferedImage newBufferedImage(int size) {
        return GraphicsEnvironment.isHeadless() ? new BufferedImage(size, size, 2) : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(size, size, 3);
    }
}

