/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.util.swing.ProgressComponent;
import org.pepsoft.util.swing.ProgressTask;
import org.pepsoft.util.swing.ProgressViewer;
import org.pepsoft.util.swing.ScrollablePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProgressComponent<T>
extends JPanel
implements ProgressReceiver,
ActionListener {
    private JButton jButton1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private ScrollablePanel scrollablePanel1;
    private ProgressTask<T> task;
    private volatile boolean cancelRequested;
    private volatile boolean exceptionReported;
    private volatile T result;
    private long start;
    private long remaining;
    private long lastUpdate;
    private int progressReports;
    private int lastReportedMinutes = Integer.MAX_VALUE;
    private Timer timer;
    private ProgressComponent.Listener<T> listener;
    private boolean timeEstimatesActivated;
    private boolean inhibitDone;
    private boolean cancelable = true;
    private List<int[]> stats;
    private static final String CLIENT_PROPERTY_INDENTATION = MultiProgressComponent.class.getName() + ".indentation";
    private static final int INDENTATION_SIZE = 32;
    private static final Logger logger = LoggerFactory.getLogger(MultiProgressComponent.class);
    private static final long serialVersionUID = 1L;

    public MultiProgressComponent() {
        this.initComponents();
        Dimension panelPrefdSize = this.scrollablePanel1.getPreferredSize();
        ProgressViewer testProgressViewer = new ProgressViewer();
        this.scrollablePanel1.add(testProgressViewer);
        panelPrefdSize.setSize(panelPrefdSize.getWidth(), testProgressViewer.getPreferredSize().getHeight() * 8.0);
        this.scrollablePanel1.remove(testProgressViewer);
        this.jScrollPane1.setMinimumSize(panelPrefdSize);
        this.scrollablePanel1.setTrackViewportWidth(true);
        this.scrollablePanel1.setTrackViewportHeight(false);
    }

    public void setListener(ProgressComponent.Listener<T> listener) {
        this.listener = listener;
    }

    public ProgressComponent.Listener<T> getListener() {
        return this.listener;
    }

    public void setTask(ProgressTask<T> task) {
        this.task = task;
    }

    public ProgressTask<?> getTask() {
        return this.task;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public boolean getCancelable() {
        return this.cancelable;
    }

    public void start() {
        if ("true".equalsIgnoreCase(System.getProperty("org.pepsoft.devMode"))) {
            this.stats = new ArrayList<int[]>();
        }
        this.jButton1.setEnabled(this.cancelable);
        this.jProgressBar1.setIndeterminate(true);
        Thread thread = new Thread(this.task.getName()){

            @Override
            public void run() {
                try {
                    MultiProgressComponent.this.result = MultiProgressComponent.this.task.execute(MultiProgressComponent.this);
                    MultiProgressComponent.this.done();
                }
                catch (Throwable t) {
                    MultiProgressComponent.this.exceptionThrown(t);
                }
            }
        };
        thread.start();
        this.start = System.currentTimeMillis();
        this.timer = new Timer(1000, this);
        this.timer.start();
    }

    public void addButton(JButton button) {
        this.jPanel1.add((Component)button, 0);
        this.jPanel1.add(Box.createHorizontalStrut(5), 1);
    }

    public void setProgress(float progress) throws ProgressReceiver.OperationCancelled {
        this.checkForCancellation();
        AwtUtils.doOnEventThreadAndWait(() -> {
            ++this.progressReports;
            long now = System.currentTimeMillis();
            long elapsed = now - this.start;
            float speed = (float)elapsed / progress;
            this.remaining = (long)((1.0f - progress) * speed);
            this.lastUpdate = now;
            if (!this.timeEstimatesActivated && elapsed >= 60000L && this.progressReports >= 10) {
                this.timeEstimatesActivated = true;
            }
            if (this.jProgressBar1.isIndeterminate()) {
                this.jProgressBar1.setIndeterminate(false);
            }
            this.jProgressBar1.setValue(Math.round(progress * 100.0f));
        });
    }

    public void exceptionThrown(Throwable exception) {
        if (!this.exceptionReported) {
            Throwable exceptionWithContext = MDCUtils.decorateWithMdcContext((Throwable)exception);
            AwtUtils.doOnEventThreadAndWait(() -> {
                this.timer.stop();
                if (this.jProgressBar1.isIndeterminate()) {
                    this.jProgressBar1.setIndeterminate(false);
                }
                this.jButton1.setEnabled(false);
                this.inhibitDone = true;
                if (ExceptionUtils.chainContains((Throwable)exception, ProgressReceiver.OperationCancelled.class)) {
                    this.jLabel2.setText("Cancelled");
                    if (this.listener != null) {
                        this.listener.cancelled();
                    }
                } else {
                    this.jLabel2.setText("Error");
                    if (this.listener != null) {
                        this.listener.exceptionThrown(exceptionWithContext);
                    }
                }
            });
            this.exceptionReported = true;
        }
    }

    public void done() {
        AwtUtils.doOnEventThreadAndWait(() -> {
            this.timer.stop();
            if (this.jProgressBar1.isIndeterminate()) {
                this.jProgressBar1.setIndeterminate(false);
            }
            this.jProgressBar1.setValue(100);
            this.jButton1.setEnabled(false);
            this.jLabel2.setText("Done");
            this.scrollablePanel1.removeAll();
            if (this.stats != null) {
                try (PrintWriter out = new PrintWriter("logs/" + FileUtils.sanitiseName((String)(this.task.getName() + "-" + new Date() + ".csv")));){
                    int second = 1;
                    out.println("second,calculated,displayed");
                    for (int[] statsRow : this.stats) {
                        out.println(second++ + "," + statsRow[0] + "," + statsRow[1]);
                    }
                }
                catch (IOException e) {
                    logger.error("I/O error while dumping statistics", (Throwable)e);
                }
            }
            if (this.listener != null && !this.inhibitDone) {
                this.listener.done(this.result);
            }
        });
    }

    public void setMessage(String message) throws ProgressReceiver.OperationCancelled {
        this.checkForCancellation();
    }

    public void checkForCancellation() throws ProgressReceiver.OperationCancelled {
        if (this.cancelRequested) {
            throw new ProgressReceiver.OperationCancelledByUser();
        }
    }

    public void reset() throws ProgressReceiver.OperationCancelled {
        this.checkForCancellation();
        AwtUtils.doOnEventThreadAndWait(() -> {
            if (this.stats != null) {
                try (PrintWriter out = new PrintWriter("logs/" + FileUtils.sanitiseName((String)(this.task.getName() + "-" + new Date() + ".csv")));){
                    int second = 1;
                    out.println("second,calculated,displayed");
                    for (int[] statsRow : this.stats) {
                        out.println(second++ + "," + statsRow[0] + "," + statsRow[1]);
                    }
                }
                catch (IOException e) {
                    logger.error("I/O error while dumping statistics", (Throwable)e);
                }
                this.stats = new ArrayList<int[]>();
            }
            this.jProgressBar1.setIndeterminate(true);
            this.start = System.currentTimeMillis();
            this.progressReports = 0;
            this.lastReportedMinutes = Integer.MAX_VALUE;
            this.timeEstimatesActivated = false;
            this.jLabel2.setText(" ");
        });
    }

    public void subProgressStarted(final SubProgressReceiver subProgressReceiver) throws ProgressReceiver.OperationCancelled {
        this.checkForCancellation();
        AwtUtils.doOnEventThreadAndWait(() -> {
            ProgressViewer progressViewer = new ProgressViewer(subProgressReceiver);
            Object parent = subProgressReceiver.getParent();
            if (parent == null) {
                this.scrollablePanel1.add((Component)progressViewer, 0);
            } else {
                boolean parentFound = false;
                do {
                    for (int i = 0; i < this.scrollablePanel1.getComponentCount(); ++i) {
                        Component component = this.scrollablePanel1.getComponent(i);
                        ProgressViewer parentViewer = (ProgressViewer)(component instanceof ProgressViewer ? component : ((JPanel)component).getComponent(1));
                        if (parentViewer.getSubProgressReceiver() != parent) continue;
                        Integer parentIndentation = (Integer)parentViewer.getClientProperty(CLIENT_PROPERTY_INDENTATION);
                        int indentation = parentIndentation != null ? parentIndentation + 1 : 1;
                        JPanel progressPanel = new JPanel();
                        progressPanel.setLayout(new BoxLayout(progressPanel, 2));
                        progressPanel.add(Box.createHorizontalStrut(indentation * 32));
                        progressPanel.add(progressViewer);
                        this.scrollablePanel1.add((Component)progressPanel, i + 1);
                        parentFound = true;
                        break;
                    }
                    parent = parent instanceof SubProgressReceiver ? ((SubProgressReceiver)parent).getParent() : null;
                } while (!parentFound && parent != null);
                if (!parentFound) {
                    this.scrollablePanel1.add(progressViewer);
                }
            }
            subProgressReceiver.addListener(new ProgressReceiver(){

                public void setProgress(float progress) {
                    if (progress >= 1.0f) {
                        AwtUtils.doOnEventThreadAndWait(() -> this.removeViewerHierarchy(subProgressReceiver));
                    }
                }

                public void exceptionThrown(Throwable exception) {
                    AwtUtils.doOnEventThreadAndWait(() -> this.removeViewerHierarchy(subProgressReceiver));
                }

                public void done() {
                    AwtUtils.doOnEventThreadAndWait(() -> this.removeViewerHierarchy(subProgressReceiver));
                }

                private void removeViewerHierarchy(SubProgressReceiver subProgressReceiver2) {
                    ProgressViewer viewer;
                    for (Component component : MultiProgressComponent.this.scrollablePanel1.getComponents()) {
                        viewer = (ProgressViewer)(component instanceof ProgressViewer ? component : ((JPanel)component).getComponent(1));
                        if (viewer.getSubProgressReceiver().getParent() != subProgressReceiver2) continue;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Progress receiver still has child; removing child. Stack trace is of child creation", viewer.getSubProgressReceiver().getCreationTrace());
                        }
                        this.removeViewerHierarchy(viewer.getSubProgressReceiver());
                    }
                    for (Component component : MultiProgressComponent.this.scrollablePanel1.getComponents()) {
                        viewer = (ProgressViewer)(component instanceof ProgressViewer ? component : ((JPanel)component).getComponent(1));
                        if (viewer.getSubProgressReceiver() != subProgressReceiver2) continue;
                        MultiProgressComponent.this.scrollablePanel1.remove(component);
                        break;
                    }
                    MultiProgressComponent.this.jScrollPane1.validate();
                }

                public void setMessage(String message) {
                }

                public void checkForCancellation() {
                }

                public void reset() {
                }

                public void subProgressStarted(SubProgressReceiver subProgressReceiver2) {
                }
            });
            this.jScrollPane1.validate();
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.timeEstimatesActivated) {
            long now = System.currentTimeMillis();
            this.remaining -= now - this.lastUpdate;
            this.lastUpdate = now;
            int minutes = (int)(this.remaining / 60000L);
            if (minutes < this.lastReportedMinutes || minutes > this.lastReportedMinutes + 1) {
                this.lastReportedMinutes = minutes;
                if (minutes < 1) {
                    this.jLabel2.setText("Less than a minute remaining");
                } else if (minutes < 90) {
                    this.jLabel2.setText("About " + (minutes + 1) + " minutes remaining");
                } else {
                    int hours = (minutes + 30) / 60;
                    this.jLabel2.setText("About " + hours + " hours remaining");
                }
            }
            if (this.stats != null) {
                this.stats.add(new int[]{minutes, this.lastReportedMinutes + 1});
            }
        } else if (this.stats != null) {
            this.stats.add(new int[]{-1, -1});
        }
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.scrollablePanel1 = new ScrollablePanel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel2.setText(" ");
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.scrollablePanel1.setLayout(new GridLayout(0, 1));
        this.jScrollPane1.setViewportView(this.scrollablePanel1);
        this.jPanel1.setLayout(new FlowLayout(4, 0, 0));
        this.jButton1.setText("Cancel");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiProgressComponent.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jProgressBar1, -1, 382, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 127, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancelRequested = true;
        this.jButton1.setEnabled(false);
    }
}

