/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.filechooser.FileSystemView;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ProcessUtils;
import org.pepsoft.util.ProgressHelper;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.XDG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DesktopUtils {
    private static final Logger logger = LoggerFactory.getLogger(DesktopUtils.class);

    private DesktopUtils() {
    }

    public static boolean open(File file) {
        try {
            Desktop.getDesktop().open(file);
            return true;
        }
        catch (IOException e) {
            try {
                if (SystemUtils.isLinux()) {
                    return ProcessUtils.runAndWait((String[])new String[]{"xdg-open", file.getAbsolutePath()}) == 0;
                }
                if (SystemUtils.isMac()) {
                    return ProcessUtils.runAndWait((String[])new String[]{"open", file.getAbsolutePath()}) == 0;
                }
                if (SystemUtils.isWindows()) {
                    return ProcessUtils.runAndWait((String[])new String[]{"start", file.getAbsolutePath()}) == 0;
                }
                throw e;
            }
            catch (IOException e2) {
                logger.error("I/O error while trying to open " + file, (Throwable)e2);
                DesktopUtils.beep();
                return false;
            }
        }
    }

    public static File getDocumentsFolder() {
        if (XDG.XDG_DOCUMENTS_DIR_FILE != null) {
            return XDG.XDG_DOCUMENTS_DIR_FILE;
        }
        if (SystemUtils.isWindows()) {
            return FileSystemView.getFileSystemView().getDefaultDirectory();
        }
        File homeDir = new File(System.getProperty("user.home"));
        File potentialDocsDir = new File(homeDir, "Documents");
        if (potentialDocsDir.isDirectory()) {
            return potentialDocsDir;
        }
        return homeDir;
    }

    public static File getPicturesFolder() {
        if (XDG.XDG_PICTURES_DIR_FILE != null) {
            return XDG.XDG_PICTURES_DIR_FILE;
        }
        File homeDir = new File(System.getProperty("user.home"));
        File potentialPicsDir = new File(homeDir, "Pictures");
        if (potentialPicsDir.isDirectory()) {
            return potentialPicsDir;
        }
        potentialPicsDir = new File(homeDir, "Photos");
        if (potentialPicsDir.isDirectory()) {
            return potentialPicsDir;
        }
        File docsDir = DesktopUtils.getDocumentsFolder();
        potentialPicsDir = new File(docsDir, "Pictures");
        if (potentialPicsDir.isDirectory()) {
            return potentialPicsDir;
        }
        potentialPicsDir = new File(docsDir, "Photos");
        if (potentialPicsDir.isDirectory()) {
            return potentialPicsDir;
        }
        return docsDir;
    }

    public static boolean open(URL url) {
        try {
            Desktop.getDesktop().browse(url.toURI());
            return true;
        }
        catch (URISyntaxException e) {
            logger.error("URI syntax exception while trying to open " + url, (Throwable)e);
            DesktopUtils.beep();
            return false;
        }
        catch (IOException | UnsupportedOperationException e) {
            if (SystemUtils.isLinux()) {
                return ProcessUtils.runAndWait((String[])new String[]{"xdg-open", url.toExternalForm()}) == 0;
            }
            if (SystemUtils.isMac()) {
                return ProcessUtils.runAndWait((String[])new String[]{"open", url.toExternalForm()}) == 0;
            }
            if (SystemUtils.isWindows()) {
                return ProcessUtils.runAndWait((String[])new String[]{"start", url.toExternalForm()}) == 0;
            }
            logger.error("{} while trying to open {}", new Object[]{e.getClass().getSimpleName(), url, e});
            DesktopUtils.beep();
            return false;
        }
    }

    public static void copyToClipboard(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
    }

    public static void setProgress(Window window, int percentage) {
        AwtUtils.doOnEventThread(() -> ProgressHelper.getInstance().setProgress(window, percentage));
    }

    public static void setProgressDone(Window window) {
        AwtUtils.doOnEventThread(() -> ProgressHelper.getInstance().setProgressDone(window));
    }

    public static void setProgressError(Window window) {
        AwtUtils.doOnEventThread(() -> ProgressHelper.getInstance().setProgressError(window));
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void main(String[] args) throws MalformedURLException {
        DesktopUtils.copyToClipboard("Testing, testing, one two three testing.");
        DesktopUtils.open(new URL("http://www.telegraaf.nl/"));
        File documentsFolder = DesktopUtils.getDocumentsFolder();
        System.out.println("Documents folder: " + documentsFolder);
        DesktopUtils.open(documentsFolder);
    }
}

