/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static byte[] toBytes(RenderedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write(image, "PNG", baos);
        return baos.toByteArray();
    }

    public static BufferedImage fromBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return ImageIO.read(bais);
    }

    public static BufferedImage createColourSquare(int size, int colour) {
        BufferedImage image = new BufferedImage(size, size, 2);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                image.setRGB(x, y, 0xFF000000 | colour);
            }
        }
        return image;
    }

    public static BufferedImage clone(BufferedImage image) {
        ColorModel cm = image.getColorModel();
        return new BufferedImage(cm, image.copyData(image.getRaster().createCompatibleWritableRaster()), cm.isAlphaPremultiplied(), null);
    }
}

