/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Component;
import java.awt.Window;
import java.util.Map;
import java.util.WeakHashMap;
import org.bridj.Pointer;
import org.bridj.ValuedEnum;
import org.bridj.cpp.com.COMRuntime;
import org.bridj.cpp.com.shell.ITaskbarList3;
import org.bridj.jawt.JAWTUtils;
import org.pepsoft.util.ProgressHelper;
import org.pepsoft.util.SystemUtils;

class ProgressHelperWindowsJava8
extends ProgressHelper {
    private final boolean enabled = SystemUtils.isWindows();
    private static final Map<Window, WindowProgress> windowHelpers = new WeakHashMap<Window, WindowProgress>();

    ProgressHelperWindowsJava8() {
    }

    @Override
    void setProgress(Window window, int percentage) {
        if (!this.enabled) {
            return;
        }
        WindowProgress windowHelper = windowHelpers.get(window);
        if (windowHelper == null) {
            windowHelper = new WindowProgress(window);
            windowHelpers.put(window, windowHelper);
            if (windowHelper.taskbarList != null) {
                windowHelper.taskbarList.SetProgressState(windowHelper.hwnd, (ValuedEnum)ITaskbarList3.TbpFlag.TBPF_NORMAL);
            }
        }
        if (windowHelper.taskbarList != null && !windowHelper.errorReported) {
            windowHelper.taskbarList.SetProgressValue(windowHelper.hwnd, (long)percentage, 100L);
        }
    }

    @Override
    void setProgressDone(Window window) {
        if (!this.enabled) {
            return;
        }
        WindowProgress windowHelper = windowHelpers.get(window);
        if (windowHelper != null) {
            if (windowHelper.taskbarList != null) {
                windowHelper.taskbarList.SetProgressState(windowHelper.hwnd, (ValuedEnum)ITaskbarList3.TbpFlag.TBPF_NOPROGRESS);
            }
            windowHelpers.remove(window);
        }
    }

    @Override
    void setProgressError(Window window) {
        if (!this.enabled) {
            return;
        }
        WindowProgress windowHelper = windowHelpers.get(window);
        if (windowHelper != null && windowHelper.taskbarList != null) {
            windowHelper.taskbarList.SetProgressState(windowHelper.hwnd, (ValuedEnum)ITaskbarList3.TbpFlag.TBPF_ERROR);
            windowHelper.errorReported = true;
        }
    }

    static class WindowProgress {
        final ITaskbarList3 taskbarList;
        final Pointer<Integer> hwnd;
        boolean errorReported;

        WindowProgress(Window window) {
            Pointer hwnd;
            ITaskbarList3 taskbarList;
            try {
                taskbarList = (ITaskbarList3)COMRuntime.newInstance(ITaskbarList3.class);
                long hwndVal = JAWTUtils.getNativePeerHandle((Component)window);
                hwnd = Pointer.pointerToAddress((long)hwndVal);
            }
            catch (ClassNotFoundException | NoClassDefFoundError | RuntimeException | UnsatisfiedLinkError e) {
                taskbarList = null;
                hwnd = null;
            }
            this.taskbarList = taskbarList;
            this.hwnd = hwnd;
        }
    }
}

