/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.util.mdc.MDCUtils;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;
import org.pepsoft.util.swing.ProgressTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ProgressComponent<T>
extends JPanel
implements ProgressReceiver,
ActionListener {
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JProgressBar jProgressBar1;
    private ProgressTask<T> task;
    private volatile boolean cancelRequested;
    private volatile T result;
    private long start;
    private long remaining;
    private long lastUpdate;
    private int progressReports;
    private int lastReportedMinutes = Integer.MAX_VALUE;
    private Timer timer;
    private Listener<T> listener;
    private boolean timeEstimatesActivated;
    private boolean inhibitDone;
    private boolean cancelable = true;
    private boolean exceptionReported;
    private List<int[]> stats;
    private static final Logger logger = LoggerFactory.getLogger(ProgressComponent.class);
    private static final long serialVersionUID = 1L;

    public ProgressComponent() {
        this.initComponents();
    }

    public void setListener(Listener<T> listener) {
        this.listener = listener;
    }

    public Listener<T> getListener() {
        return this.listener;
    }

    public void setTask(ProgressTask<T> task) {
        this.task = task;
        this.jLabel1.setText(task.getName());
    }

    public ProgressTask<?> getTask() {
        return this.task;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public boolean getCancelable() {
        return this.cancelable;
    }

    public void start() {
        if ("true".equalsIgnoreCase(System.getProperty("org.pepsoft.devMode"))) {
            this.stats = new ArrayList<int[]>();
        }
        this.jButton1.setEnabled(this.cancelable);
        this.jProgressBar1.setIndeterminate(true);
        final Map mdcContextMap = MDC.getCopyOfContextMap();
        Thread thread = new Thread(this.task.getName()){

            @Override
            public void run() {
                if (mdcContextMap != null) {
                    MDC.setContextMap((Map)mdcContextMap);
                } else {
                    MDC.clear();
                }
                try {
                    try {
                        ProgressComponent.this.result = ProgressComponent.this.task.execute(ProgressComponent.this);
                    }
                    catch (Error | RuntimeException e) {
                        throw new MDCWrappingRuntimeException(e);
                    }
                    ProgressComponent.this.done();
                }
                catch (Throwable t) {
                    ProgressComponent.this.exceptionThrown(t);
                }
                finally {
                    MDC.clear();
                }
            }
        };
        thread.start();
        this.start = System.currentTimeMillis();
        this.timer = new Timer(1000, this);
        this.timer.start();
    }

    public void setProgress(float progress) throws ProgressReceiver.OperationCancelled {
        this.checkForCancellation();
        AwtUtils.doOnEventThreadAndWait(() -> {
            ++this.progressReports;
            long now = System.currentTimeMillis();
            long elapsed = now - this.start;
            float speed = (float)elapsed / progress;
            this.remaining = (long)((1.0f - progress) * speed);
            this.lastUpdate = now;
            if (!this.timeEstimatesActivated && elapsed >= 60000L && this.progressReports >= 10) {
                this.timeEstimatesActivated = true;
            }
            if (this.jProgressBar1.isIndeterminate()) {
                this.jProgressBar1.setIndeterminate(false);
            }
            this.jProgressBar1.setValue(Math.round(progress * 100.0f));
        });
    }

    public void exceptionThrown(Throwable exception) {
        if (!this.exceptionReported) {
            Throwable exceptionWithContext = MDCUtils.decorateWithMdcContext((Throwable)exception);
            AwtUtils.doOnEventThreadAndWait(() -> {
                this.timer.stop();
                if (this.jProgressBar1.isIndeterminate()) {
                    this.jProgressBar1.setIndeterminate(false);
                }
                this.jButton1.setEnabled(false);
                this.inhibitDone = true;
                if (ExceptionUtils.chainContains((Throwable)exception, ProgressReceiver.OperationCancelled.class)) {
                    this.jLabel2.setText("Cancelled");
                    if (this.listener != null) {
                        this.listener.cancelled();
                    }
                } else {
                    this.jLabel2.setText("Error");
                    if (this.listener != null) {
                        this.listener.exceptionThrown(exceptionWithContext);
                    }
                }
            });
            this.exceptionReported = true;
        }
    }

    public void done() {
        AwtUtils.doOnEventThreadAndWait(() -> {
            this.timer.stop();
            if (this.jProgressBar1.isIndeterminate()) {
                this.jProgressBar1.setIndeterminate(false);
            }
            this.jProgressBar1.setValue(100);
            this.jButton1.setEnabled(false);
            this.jLabel2.setText("Done");
            if (this.stats != null) {
                try (PrintWriter out = new PrintWriter("logs/" + FileUtils.sanitiseName((String)(this.task.getName() + "-" + new Date() + ".csv")));){
                    int second = 1;
                    out.println("second,calculated,displayed");
                    for (int[] statsRow : this.stats) {
                        out.println(second++ + "," + statsRow[0] + "," + statsRow[1]);
                    }
                }
                catch (IOException e) {
                    logger.error("I/O error while dumping statistics", (Throwable)e);
                }
            }
            if (this.listener != null && !this.inhibitDone) {
                this.listener.done(this.result);
            }
        });
    }

    public void setMessage(String message) throws ProgressReceiver.OperationCancelled {
        this.checkForCancellation();
        AwtUtils.doOnEventThreadAndWait(() -> this.jLabel1.setText(this.task.getName() + (message != null ? ", " + message : "")));
    }

    public void checkForCancellation() throws ProgressReceiver.OperationCancelled {
        if (this.cancelRequested) {
            throw new ProgressReceiver.OperationCancelledByUser();
        }
    }

    public void reset() throws ProgressReceiver.OperationCancelled {
        this.checkForCancellation();
        AwtUtils.doOnEventThreadAndWait(() -> {
            if (this.stats != null) {
                try (PrintWriter out = new PrintWriter("logs/" + FileUtils.sanitiseName((String)(this.task.getName() + "-" + new Date() + ".csv")));){
                    int second = 1;
                    out.println("second,calculated,displayed");
                    for (int[] statsRow : this.stats) {
                        out.println(second++ + "," + statsRow[0] + "," + statsRow[1]);
                    }
                }
                catch (IOException e) {
                    logger.error("I/O error while dumping statistics", (Throwable)e);
                }
                this.stats = new ArrayList<int[]>();
            }
            this.jProgressBar1.setIndeterminate(true);
            this.start = System.currentTimeMillis();
            this.progressReports = 0;
            this.lastReportedMinutes = Integer.MAX_VALUE;
            this.timeEstimatesActivated = false;
            this.jLabel2.setText(" ");
        });
    }

    public void subProgressStarted(SubProgressReceiver subProgressReceiver) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.timeEstimatesActivated) {
            long now = System.currentTimeMillis();
            this.remaining -= now - this.lastUpdate;
            this.lastUpdate = now;
            int minutes = (int)(this.remaining / 60000L);
            if (minutes < this.lastReportedMinutes || minutes > this.lastReportedMinutes + 1) {
                this.lastReportedMinutes = minutes;
                if (minutes < 1) {
                    this.jLabel2.setText("Less than a minute remaining");
                } else if (minutes < 90) {
                    this.jLabel2.setText("About " + (minutes + 1) + " minutes remaining");
                } else {
                    int hours = (minutes + 30) / 60;
                    this.jLabel2.setText("About " + hours + " hours remaining");
                }
            }
            if (this.stats != null) {
                this.stats.add(new int[]{minutes, this.lastReportedMinutes + 1});
            }
        } else if (this.stats != null) {
            this.stats.add(new int[]{-1, -1});
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel1.setText(" ");
        this.jLabel2.setText(" ");
        this.jButton1.setText("Cancel");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(this::jButton1ActionPerformed);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, -1, 376, Short.MAX_VALUE).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 313, Short.MAX_VALUE).addComponent(this.jButton1)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jLabel2))));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cancelRequested = true;
        this.jButton1.setEnabled(false);
    }

    public static interface Listener<T> {
        public void exceptionThrown(Throwable var1);

        public void done(T var1);

        public void cancelled();
    }
}

