/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.IntegerAttributeKey;
import org.pepsoft.util.swing.TileListener;
import org.pepsoft.util.swing.TileProvider;
import org.pepsoft.util.swing.UnknownTileProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiledImageViewer
extends JComponent
implements TileListener,
MouseListener,
MouseMotionListener,
ComponentListener,
HierarchyListener,
Cloneable {
    private final boolean leftClickDrags;
    private final boolean paintCentre;
    private final int threads;
    private final Object TILE_CACHE_LOCK = new Object();
    private final SortedMap<Integer, TileProvider> tileProviders = new TreeMap<Integer, TileProvider>();
    private final Map<TileProvider, Map<Point, Reference<? extends Image>>> tileCaches = new HashMap<TileProvider, Map<Point, Reference<? extends Image>>>();
    private final Map<TileProvider, Map<Point, Reference<? extends Image>>> dirtyTileCaches = new HashMap<TileProvider, Map<Point, Reference<? extends Image>>>();
    private final Map<String, Overlay> overlays = new HashMap<String, Overlay>();
    private final int tileProviderZoomCutoff;
    private final Map<TileProvider, Integer> tileProviderZoom = new WeakHashMap<TileProvider, Integer>();
    protected int viewX;
    protected int viewY;
    protected int previousX;
    protected int previousY;
    protected int markerX;
    protected int markerY;
    protected int xOffset;
    protected int yOffset;
    private int zoom = GUIUtils.getUIScale() < 1.5f ? 0 : 1;
    private int gridSize = 128;
    private ExecutorService tileRenderers;
    private boolean dragging;
    private boolean paintMarker;
    private boolean paintGrid;
    private BlockingQueue<Runnable> queue;
    private ViewListener viewListener;
    private Color gridColour = Color.BLACK;
    private BufferedImage backgroundImage;
    private BackgroundImageMode backgroundImageMode = BackgroundImageMode.CENTRE_REPEAT;
    private volatile boolean inhibitUpdates;
    private int labelScale = 1;
    public static final int TILE_SIZE = 128;
    public static final int TILE_SIZE_BITS = 7;
    public static final int TILE_SIZE_MASK = 127;
    public static final IntegerAttributeKey ADVANCED_SETTING_MAX_TILE_RENDER_THREADS = new IntegerAttributeKey("display.maxTileRenderThreads", Integer.valueOf(8));
    static final AtomicLong jobSeq = new AtomicLong(Long.MIN_VALUE);
    private static final Reference<VolatileImage> RENDERING = new SoftReference<Object>(null);
    private static final VolatileImage NO_TILE = new VolatileImage(){

        @Override
        public BufferedImage getSnapshot() {
            return null;
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public Graphics2D createGraphics() {
            return null;
        }

        @Override
        public int validate(GraphicsConfiguration gc) {
            return 0;
        }

        @Override
        public boolean contentsLost() {
            return false;
        }

        @Override
        public ImageCapabilities getCapabilities() {
            return null;
        }

        @Override
        public int getWidth(ImageObserver observer) {
            return 0;
        }

        @Override
        public int getHeight(ImageObserver observer) {
            return 0;
        }

        @Override
        public Object getProperty(String name, ImageObserver observer) {
            return null;
        }
    };
    private static final Font NORMAL_FONT = new Font("SansSerif", 0, (int)(10.0f * GUIUtils.getUIScale()));
    private static final Font BOLD_FONT = new Font("SansSerif", 1, (int)(10.0f * GUIUtils.getUIScale()));
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TiledImageViewer.class);

    public TiledImageViewer() {
        this(true, true, 0);
    }

    public TiledImageViewer(boolean leftClickDrags, boolean paintCentre) {
        this(leftClickDrags, paintCentre, 0);
    }

    public TiledImageViewer(boolean leftClickDrags, boolean paintCentre, int tileProviderZoomCutoff) {
        this.leftClickDrags = leftClickDrags;
        this.paintCentre = paintCentre;
        this.tileProviderZoomCutoff = tileProviderZoomCutoff;
        String maxThreads = System.getProperty("org.pepsoft.worldpainter." + TiledImageViewer.ADVANCED_SETTING_MAX_TILE_RENDER_THREADS.key);
        this.threads = maxThreads != null ? ADVANCED_SETTING_MAX_TILE_RENDER_THREADS.toValue(maxThreads) : Math.min(Math.max(Runtime.getRuntime().availableProcessors() - 1, 1), (Integer)TiledImageViewer.ADVANCED_SETTING_MAX_TILE_RENDER_THREADS.defaultValue);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.addHierarchyListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setOpaque(true);
    }

    public Collection<TileProvider> getTileProviders() {
        return Collections.unmodifiableCollection(this.tileProviders.values());
    }

    public int getTileProviderCount() {
        return this.tileProviders.size();
    }

    public void setTileProvider(TileProvider tileProvider) {
        this.setTileProvider(0, tileProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileProvider(int layer, TileProvider tileProvider) {
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            TileProvider oldTileProvider = (TileProvider)this.tileProviders.remove(layer);
            Integer zoom = null;
            Map<Object, Object> dirtyTileCache = new HashMap();
            if (oldTileProvider != null) {
                zoom = this.tileProviderZoom.remove(oldTileProvider);
                oldTileProvider.removeTileListener(this);
                dirtyTileCache = this.dirtyTileCaches.remove(oldTileProvider);
                Map<Point, Reference<? extends Image>> tileCache = this.tileCaches.remove(oldTileProvider);
                for (Map.Entry<Point, Reference<? extends Image>> entry : tileCache.entrySet()) {
                    Image tileImage;
                    Reference<? extends Image> tileImageRef = entry.getValue();
                    if (tileImageRef == RENDERING || (tileImage = tileImageRef.get()) == null) continue;
                    dirtyTileCache.put(entry.getKey(), tileImageRef);
                }
                if (this.queue != null) {
                    Iterator i = this.queue.iterator();
                    while (i.hasNext()) {
                        if (((TileRenderJob)i.next()).tileProvider != oldTileProvider) continue;
                        i.remove();
                    }
                }
            }
            if (tileProvider.isZoomSupported()) {
                if (zoom != null) {
                    tileProvider.setZoom(this.zoom + zoom <= this.tileProviderZoomCutoff ? this.zoom + zoom : this.tileProviderZoomCutoff);
                } else {
                    tileProvider.setZoom(this.zoom <= this.tileProviderZoomCutoff ? this.zoom : this.tileProviderZoomCutoff);
                }
            }
            tileProvider.addTileListener(this);
            this.tileProviders.put(layer, tileProvider);
            if (zoom != null) {
                this.tileProviderZoom.put(tileProvider, zoom);
            }
            this.tileCaches.put(tileProvider, new HashMap());
            this.dirtyTileCaches.put(tileProvider, dirtyTileCache);
            this.startRenderersIfApplicable();
        }
        this.fireViewChangedEvent();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTileProvider(int layer) {
        boolean providerRemoved = false;
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            TileProvider tileProvider = (TileProvider)this.tileProviders.remove(layer);
            if (tileProvider != null) {
                this.tileProviderZoom.remove(tileProvider);
                tileProvider.removeTileListener(this);
                this.tileCaches.remove(tileProvider);
                this.dirtyTileCaches.remove(tileProvider);
                if (this.queue != null) {
                    Iterator i = this.queue.iterator();
                    while (i.hasNext()) {
                        if (((TileRenderJob)i.next()).tileProvider != tileProvider) continue;
                        i.remove();
                    }
                }
                providerRemoved = true;
            }
        }
        if (providerRemoved) {
            this.fireViewChangedEvent();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTileProviders() {
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            for (TileProvider tileProvider : this.tileProviders.values()) {
                tileProvider.removeTileListener(this);
            }
            this.tileProviders.clear();
            this.tileProviderZoom.clear();
            if (this.queue != null) {
                this.queue.clear();
            }
            this.tileCaches.clear();
            this.dirtyTileCaches.clear();
        }
        this.fireViewChangedEvent();
        this.repaint();
    }

    public int getViewX() {
        if (this.zoom == 0) {
            return this.viewX;
        }
        if (this.zoom < 0) {
            return this.viewX << -this.zoom;
        }
        return this.viewX >> this.zoom;
    }

    public int getViewY() {
        if (this.zoom == 0) {
            return this.viewY;
        }
        if (this.zoom < 0) {
            return this.viewY << -this.zoom;
        }
        return this.viewY >> this.zoom;
    }

    public Rectangle getExtent() {
        Rectangle extent = null;
        for (TileProvider tileProvider : this.tileProviders.values()) {
            Rectangle providerExtent = tileProvider.getExtent();
            if (providerExtent == null) continue;
            providerExtent = this.getTileBounds(providerExtent.x, providerExtent.y, providerExtent.width, providerExtent.height, this.zoom);
            if (extent == null) {
                extent = providerExtent;
                continue;
            }
            extent = extent.union(providerExtent);
        }
        return extent;
    }

    public Point getViewLocation() {
        if (this.zoom == 0) {
            return new Point(this.viewX, this.viewY);
        }
        if (this.zoom < 0) {
            return new Point(this.viewX << -this.zoom, this.viewY << -this.zoom);
        }
        return new Point(this.viewX >> this.zoom, this.viewY >> this.zoom);
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.setZoom(zoom, this.xOffset, this.yOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoom(int zoom, int locusX, int locusY) {
        if (zoom != this.zoom) {
            int dZoom = zoom - this.zoom;
            this.zoom = zoom;
            if (this.queue != null) {
                this.queue.clear();
            }
            Object object = this.TILE_CACHE_LOCK;
            synchronized (object) {
                for (TileProvider tileProvider : this.tileProviders.values()) {
                    if (tileProvider.isZoomSupported()) {
                        tileProvider.setZoom(zoom + this.tileProviderZoom.getOrDefault(tileProvider, 0) <= this.tileProviderZoomCutoff ? zoom + this.tileProviderZoom.getOrDefault(tileProvider, 0) : this.tileProviderZoomCutoff);
                    }
                    this.dirtyTileCaches.put(tileProvider, new HashMap());
                    this.tileCaches.put(tileProvider, new HashMap());
                }
            }
            if (dZoom < 0) {
                this.viewX >>= -dZoom;
                this.viewY >>= -dZoom;
            } else {
                this.viewX <<= dZoom;
                this.viewY <<= dZoom;
            }
            this.fireViewChangedEvent();
            this.repaint();
        }
    }

    public void resetZoom() {
        this.setZoom(GUIUtils.getUIScale() < 1.5f ? 0 : 1);
    }

    public Point getMarkerCoords() {
        return this.paintMarker ? new Point(this.markerX, this.markerY) : null;
    }

    public void setMarkerCoords(Point markerCoords) {
        if (markerCoords != null) {
            this.markerX = markerCoords.x;
            this.markerY = markerCoords.y;
            this.paintMarker = true;
        } else {
            this.paintMarker = false;
        }
        this.repaint();
    }

    public boolean isPaintGrid() {
        return this.paintGrid;
    }

    public void setPaintGrid(boolean paintGrid) {
        if (paintGrid != this.paintGrid) {
            this.paintGrid = paintGrid;
            this.repaint();
        }
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        if (gridSize != this.gridSize) {
            this.gridSize = gridSize;
            this.repaint();
        }
    }

    public void moveTo(Point coords) {
        this.moveTo(coords.x, coords.y);
    }

    public void moveTo(int x, int y) {
        if (this.zoom < 0) {
            x >>= -this.zoom;
            y >>= -this.zoom;
        } else if (this.zoom > 0) {
            x <<= this.zoom;
            y <<= this.zoom;
        }
        if (this.viewX != x || this.viewY != y) {
            this.viewX = x;
            this.viewY = y;
            this.fireViewChangedEvent();
            this.repaint();
        }
    }

    public void moveToMarker() {
        if (this.paintMarker) {
            this.moveTo(this.markerX, this.markerY);
        }
    }

    public void moveToOrigin() {
        this.moveTo(0, 0);
    }

    public void moveBy(int dx, int dy) {
        if (dx != 0 || dy != 0) {
            this.viewX += dx;
            this.viewY += dy;
            this.fireViewChangedEvent();
            this.repaint();
        }
    }

    public void refresh() {
        this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean keepDirtyTiles) {
        this.queue.clear();
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            for (TileProvider tileProvider : this.tileProviders.values()) {
                if (keepDirtyTiles) {
                    Map<Point, Reference<? extends Image>> dirtyTileCache = this.tileCaches.get(tileProvider);
                    Iterator<Map.Entry<Point, Reference<? extends Image>>> i = dirtyTileCache.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<Point, Reference<? extends Image>> entry = i.next();
                        Point coords = entry.getKey();
                        if (tileProvider.isTilePresent(coords.x, coords.y)) continue;
                        i.remove();
                    }
                    this.dirtyTileCaches.put(tileProvider, dirtyTileCache);
                } else {
                    this.dirtyTileCaches.put(tileProvider, new HashMap());
                }
                this.tileCaches.put(tileProvider, new HashMap());
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(TileProvider tileProvider, int x, int y) {
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            int effectiveZoom;
            Point coords = new Point(x, y);
            Map<Point, Reference<? extends Image>> tileCache = this.tileCaches.get(tileProvider);
            Reference<? extends Image> tileRef = tileCache.remove(coords);
            int n = effectiveZoom = tileProvider.isZoomSupported() && this.zoom < 0 ? 0 : this.zoom;
            if (tileRef != RENDERING) {
                Image tile;
                Image image = tile = tileRef != null ? tileRef.get() : null;
                if (tile != null) {
                    this.dirtyTileCaches.get(tileProvider).put(coords, tileRef);
                }
                if (this.isTileVisible(x, y, effectiveZoom)) {
                    this.scheduleTile(tileCache, coords, tileProvider, this.dirtyTileCaches.get(tileProvider), effectiveZoom, tile != NO_TILE ? tile : null);
                }
            } else if (this.isTileVisible(x, y, effectiveZoom)) {
                this.scheduleTile(tileCache, coords, tileProvider, this.dirtyTileCaches.get(tileProvider), effectiveZoom, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(TileProvider tileProvider, Set<Point> tiles) {
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            Map<Point, Reference<? extends Image>> tileCache = this.tileCaches.get(tileProvider);
            Map<Point, Reference<? extends Image>> dirtyTileCache = this.dirtyTileCaches.get(tileProvider);
            int effectiveZoom = tileProvider.isZoomSupported() && this.zoom < 0 ? 0 : this.zoom;
            for (Point coords : tiles) {
                Reference<? extends Image> tileRef = tileCache.remove(coords);
                if (tileRef != RENDERING) {
                    Image tile;
                    Image image = tile = tileRef != null ? tileRef.get() : null;
                    if (tile != null) {
                        dirtyTileCache.put(coords, tileRef);
                    }
                    if (!this.isTileVisible(coords.x, coords.y, effectiveZoom)) continue;
                    this.scheduleTile(tileCache, coords, tileProvider, dirtyTileCache, effectiveZoom, tile != NO_TILE ? tile : null);
                    continue;
                }
                if (!this.isTileVisible(coords.x, coords.y, effectiveZoom)) continue;
                this.scheduleTile(tileCache, coords, tileProvider, dirtyTileCache, effectiveZoom, null);
            }
        }
    }

    @Deprecated
    public void reset() {
        this.viewX = 0;
        this.viewY = 0;
        if (this.zoom == -2) {
            this.fireViewChangedEvent();
        } else {
            this.setZoom(-2);
        }
        this.repaint();
    }

    public final Point worldToView(Point coords) {
        return this.worldToView(coords.x, coords.y);
    }

    public final Point worldToView(int x, int y) {
        return this.zoom == 0 ? new Point(x - this.viewX + this.xOffset, y - this.viewY + this.yOffset) : (this.zoom < 0 ? new Point((x >> -this.zoom) - this.viewX + this.xOffset, (y >> -this.zoom) - this.viewY + this.yOffset) : new Point((x << this.zoom) - this.viewX + this.xOffset, (y << this.zoom) - this.viewY + this.yOffset));
    }

    public final Point viewToWorld(Point coords) {
        return this.viewToWorld(coords.x, coords.y, this.zoom);
    }

    public final Point viewToWorld(int x, int y) {
        return this.viewToWorld(x, y, this.zoom);
    }

    public final Point viewToWorld(Point coords, int effectiveZoom) {
        return this.viewToWorld(coords.x, coords.y, effectiveZoom);
    }

    public final Point viewToWorld(int x, int y, int effectiveZoom) {
        return effectiveZoom == 0 ? new Point(x + this.viewX - this.xOffset, y + this.viewY - this.yOffset) : (effectiveZoom < 0 ? new Point(x + this.viewX - this.xOffset << -effectiveZoom, y + this.viewY - this.yOffset << -effectiveZoom) : new Point(x + this.viewX - this.xOffset >> effectiveZoom, y + this.viewY - this.yOffset >> effectiveZoom));
    }

    public final Rectangle worldToView(Rectangle coords) {
        return this.worldToView(coords.x, coords.y, coords.width, coords.height, this.zoom);
    }

    public final Rectangle worldToView(int x, int y, int width, int height) {
        return this.worldToView(x, y, width, height, this.zoom);
    }

    public final Rectangle worldToView(Rectangle coords, int effectiveZoom) {
        return this.worldToView(coords.x, coords.y, coords.width, coords.height, effectiveZoom);
    }

    public final Rectangle worldToView(int x, int y, int width, int height, int effectiveZoom) {
        return effectiveZoom == 0 ? new Rectangle(x - this.viewX + this.xOffset, y - this.viewY + this.yOffset, width, height) : (effectiveZoom < 0 ? new Rectangle((x >> -effectiveZoom) - this.viewX + this.xOffset, (y >> -effectiveZoom) - this.viewY + this.yOffset, width >> -effectiveZoom, height >> -effectiveZoom) : new Rectangle((x << effectiveZoom) - this.viewX + this.xOffset, (y << effectiveZoom) - this.viewY + this.yOffset, width << effectiveZoom, height << effectiveZoom));
    }

    public final Rectangle viewToWorld(Rectangle coords) {
        return this.viewToWorld(coords.x, coords.y, coords.width, coords.height);
    }

    public final Rectangle viewToWorld(int x, int y, int width, int height) {
        return this.zoom == 0 ? new Rectangle(x + this.viewX - this.xOffset, y + this.viewY - this.yOffset, width, height) : (this.zoom < 0 ? new Rectangle(x + this.viewX - this.xOffset << -this.zoom, y + this.viewY - this.yOffset << -this.zoom, width << -this.zoom, height << -this.zoom) : new Rectangle(x + this.viewX - this.xOffset >> this.zoom, y + this.viewY - this.yOffset >> this.zoom, width >> this.zoom, height >> this.zoom));
    }

    public ViewListener getViewListener() {
        return this.viewListener;
    }

    public void setViewListener(ViewListener viewListener) {
        this.viewListener = viewListener;
    }

    public void addOverlay(String key, int x, Component componentToTrack, BufferedImage overlay) {
        this.overlays.put(key, new Overlay(componentToTrack, key, x, overlay));
        this.repaint();
    }

    public void removeOverlay(String key) {
        if (this.overlays.containsKey(key)) {
            this.overlays.remove(key);
            this.repaint();
        }
    }

    public Color getGridColour() {
        return this.gridColour;
    }

    public void setGridColour(Color gridColour) {
        if (gridColour == null) {
            throw new NullPointerException();
        }
        if (!gridColour.equals(this.gridColour)) {
            this.gridColour = gridColour;
            this.repaint();
        }
    }

    public BufferedImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(BufferedImage backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.repaint();
    }

    public BackgroundImageMode getBackgroundImageMode() {
        return this.backgroundImageMode;
    }

    public void setBackgroundImageMode(BackgroundImageMode backgroundImageMode) {
        if (backgroundImageMode != this.backgroundImageMode) {
            this.backgroundImageMode = backgroundImageMode;
            if (this.backgroundImage != null) {
                this.repaint();
            }
        }
    }

    public boolean isInhibitUpdates() {
        return this.inhibitUpdates;
    }

    public void setInhibitUpdates(boolean inhibitUpdates) {
        if (inhibitUpdates != this.inhibitUpdates) {
            this.inhibitUpdates = inhibitUpdates;
            if (!inhibitUpdates) {
                this.refresh(true);
            }
        }
    }

    public int getLabelScale() {
        return this.labelScale;
    }

    public void setLabelScale(int labelScale) {
        if (labelScale != this.labelScale) {
            this.labelScale = labelScale;
            if (this.paintGrid) {
                this.repaint();
            }
        }
    }

    public void setTileProviderZoom(TileProvider tileProvider, int zoom) {
        this.tileProviderZoom.put(tileProvider, zoom);
        tileProvider.setZoom(this.zoom + zoom <= this.tileProviderZoomCutoff ? this.zoom + zoom : this.tileProviderZoomCutoff);
        this.repaint();
    }

    public Rectangle getVisibleArea() {
        return new Rectangle(this.viewToWorld(0, 0, this.getWidth(), this.getHeight()));
    }

    public TiledImageViewer clone() {
        TiledImageViewer clone = new TiledImageViewer(this.leftClickDrags, this.paintCentre, this.tileProviderZoomCutoff);
        clone.viewX = this.viewX;
        clone.viewY = this.viewY;
        clone.previousX = this.previousX;
        clone.previousY = this.previousY;
        clone.markerX = this.markerX;
        clone.markerY = this.markerY;
        clone.xOffset = this.xOffset;
        clone.yOffset = this.yOffset;
        clone.zoom = this.zoom;
        clone.gridSize = this.gridSize;
        clone.paintMarker = this.paintMarker;
        clone.paintGrid = this.paintGrid;
        clone.gridColour = this.gridColour;
        clone.backgroundImage = this.backgroundImage;
        clone.backgroundImageMode = this.backgroundImageMode;
        clone.inhibitUpdates = this.inhibitUpdates;
        clone.labelScale = this.labelScale;
        clone.tileProviders.putAll(this.tileProviders);
        clone.tileProviderZoom.putAll(this.tileProviderZoom);
        this.tileCaches.forEach((tileProvider, cache) -> {
            Map cfr_ignored_0 = clone.tileCaches.put((TileProvider)tileProvider, new HashMap(cache));
        });
        this.dirtyTileCaches.forEach((tileProvider, cache) -> {
            Map cfr_ignored_0 = clone.dirtyTileCaches.put((TileProvider)tileProvider, new HashMap(cache));
        });
        return clone;
    }

    protected final boolean isTileVisible(int x, int y, int effectiveZoom) {
        return new Rectangle(0, 0, this.getWidth(), this.getHeight()).intersects(this.getTileBounds(x, y, effectiveZoom));
    }

    protected final Rectangle getTileBounds(int x, int y) {
        return this.getTileBounds(x, y, this.zoom);
    }

    protected final Rectangle getTileBounds(int x, int y, int effectiveZoom) {
        return this.worldToView(x << 7, y << 7, 128, 128, effectiveZoom);
    }

    protected final Rectangle getTileBounds(int x, int y, int width, int height, int effectiveZoom) {
        return this.worldToView(x << 7, y << 7, 128 * width, 128 * height, effectiveZoom);
    }

    protected final float transformGraphics(Graphics2D g2) {
        g2.translate(this.getWidth() / 2, this.getHeight() / 2);
        g2.translate(-this.viewX, -this.viewY);
        if (this.zoom != 0) {
            float scale = (float)Math.pow(2.0, this.zoom);
            g2.scale(scale, scale);
            return scale;
        }
        return 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintMarkerIfApplicable(Graphics g2) {
        if (this.paintMarker) {
            Color savedColour = g2.getColor();
            try {
                g2.setColor(Color.RED);
                Point markerCoords = this.worldToView(this.markerX, this.markerY);
                g2.drawLine(markerCoords.x - 5, markerCoords.y, markerCoords.x + 5, markerCoords.y);
                g2.drawLine(markerCoords.x, markerCoords.y - 5, markerCoords.x, markerCoords.y + 5);
            }
            finally {
                g2.setColor(savedColour);
            }
        }
    }

    private void startRenderersIfApplicable() {
        if (this.tileRenderers == null && this.isDisplayable()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting " + this.threads + " tile rendering threads");
            }
            this.queue = new PriorityBlockingQueue<Runnable>();
            this.tileRenderers = new ThreadPoolExecutor(this.threads, this.threads, 0L, TimeUnit.MILLISECONDS, this.queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintGridIfApplicable(Graphics2D g2) {
        if (!this.paintGrid) {
            return;
        }
        Color savedColour = g2.getColor();
        Stroke savedStroke = g2.getStroke();
        Font savedFont = g2.getFont();
        Object savedTextAAHint = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            Point lineStartInView;
            int effectiveGridSize = this.gridSize;
            if (this.zoom < 0) {
                int minGridSize = Math.min(this.gridSize, 32);
                while (effectiveGridSize >> -this.zoom < minGridSize) {
                    effectiveGridSize *= 2;
                }
            }
            Rectangle clipInWorld = this.viewToWorld(g2.getClipBounds());
            int x1 = (clipInWorld.x / effectiveGridSize - 1) * effectiveGridSize;
            int x2 = ((clipInWorld.x + clipInWorld.width) / effectiveGridSize + 1) * effectiveGridSize;
            int y1 = (clipInWorld.y / effectiveGridSize - 1) * effectiveGridSize;
            int y2 = ((clipInWorld.y + clipInWorld.height) / effectiveGridSize + 1) * effectiveGridSize;
            g2.setColor(this.gridColour);
            Rectangle2D fontBounds = BOLD_FONT.getStringBounds(this.labelScale < 5 ? "-00000" : "-000000", g2.getFontRenderContext());
            int fontHeight = (int)Math.round(fontBounds.getHeight());
            int fontWidth = (int)Math.round(fontBounds.getWidth());
            int leftClear = fontWidth + 4;
            int topClear = fontHeight + 6;
            BasicStroke normalStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
            BasicStroke regionBorderStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{6.0f, 2.0f}, 0.0f);
            boolean drawRegionBorders = this.gridSize <= 512 && (this.gridSize & this.gridSize - 1) == 0;
            int width = this.getWidth();
            int height = this.getHeight();
            int xLabelSkip = effectiveGridSize;
            int yLabelSkip = effectiveGridSize;
            float scale = (float)Math.pow(2.0, this.getZoom());
            while ((float)xLabelSkip * scale < (float)fontWidth) {
                xLabelSkip += effectiveGridSize;
            }
            while ((float)yLabelSkip * scale < (float)fontHeight) {
                yLabelSkip += effectiveGridSize;
            }
            g2.setStroke(normalStroke);
            g2.setFont(NORMAL_FONT);
            boolean normalFontInstalled = true;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            boolean normalStrokeInstalled = true;
            for (int x = x1; x <= x2; x += effectiveGridSize) {
                if (x == 0 || drawRegionBorders && x % 512 == 0) {
                    g2.setStroke(regionBorderStroke);
                    normalStrokeInstalled = false;
                } else if (!normalStrokeInstalled) {
                    g2.setStroke(normalStroke);
                    normalStrokeInstalled = true;
                }
                lineStartInView = this.worldToView(x, 0);
                if (lineStartInView.x + 2 < leftClear) continue;
                if (x % xLabelSkip == 0) {
                    g2.drawLine(lineStartInView.x, 0, lineStartInView.x, height);
                    if (drawRegionBorders && x % 512 == 0) {
                        g2.setFont(BOLD_FONT);
                        normalFontInstalled = false;
                    } else if (!normalFontInstalled) {
                        g2.setFont(NORMAL_FONT);
                        normalFontInstalled = true;
                    }
                    g2.drawString(Integer.toString(x * this.labelScale), lineStartInView.x + 2, fontHeight + 2);
                    continue;
                }
                g2.drawLine(lineStartInView.x, topClear, lineStartInView.x, height);
            }
            for (int y = y1; y <= y2; y += effectiveGridSize) {
                if (y == 0 || drawRegionBorders && y % 512 == 0) {
                    g2.setStroke(regionBorderStroke);
                    normalStrokeInstalled = false;
                } else if (!normalStrokeInstalled) {
                    g2.setStroke(normalStroke);
                    normalStrokeInstalled = true;
                }
                lineStartInView = this.worldToView(0, y);
                if (y % yLabelSkip == 0) {
                    if (lineStartInView.y + 2 >= topClear) {
                        g2.drawLine(0, lineStartInView.y, width, lineStartInView.y);
                    }
                    if (drawRegionBorders && y % 512 == 0) {
                        g2.setFont(BOLD_FONT);
                        normalFontInstalled = false;
                    } else if (!normalFontInstalled) {
                        g2.setFont(NORMAL_FONT);
                        normalFontInstalled = true;
                    }
                    g2.drawString(Integer.toString(y * this.labelScale), 2, lineStartInView.y - 2);
                    continue;
                }
                if (lineStartInView.y + 2 < topClear) continue;
                g2.drawLine(leftClear, lineStartInView.y, width, lineStartInView.y);
            }
        }
        finally {
            g2.setColor(savedColour);
            g2.setStroke(savedStroke);
            g2.setFont(savedFont);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedTextAAHint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clipBounds = g2.getClipBounds();
        g2.setColor(this.getBackground());
        this.paintBackground(g2, clipBounds);
        if (this.tileProviders.isEmpty()) {
            return;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        for (TileProvider tileProvider : this.tileProviders.values()) {
            int effectiveZoom;
            Integer tileProviderZoom = this.tileProviderZoom.getOrDefault(tileProvider, 0);
            int n = effectiveZoom = tileProvider.isZoomSupported() && this.zoom + tileProviderZoom < this.tileProviderZoomCutoff ? 0 : this.zoom + tileProviderZoom - this.tileProviderZoomCutoff;
            if (logger.isTraceEnabled()) {
                logger.trace("Provider {}: zoomSupported: {}, this.zoom: {}, tileProviderZoom: {}, effectiveZoom: {}, tileProvider.getZoom(): {}", new Object[]{tileProvider, tileProvider.isZoomSupported(), this.zoom, tileProviderZoom, effectiveZoom, tileProvider.getZoom()});
            }
            Point topLeftTileCoords = this.viewToWorld(clipBounds.getLocation(), effectiveZoom);
            int leftTile = topLeftTileCoords.x >> 7;
            int topTile = topLeftTileCoords.y >> 7;
            Point bottomRightTileCoords = this.viewToWorld(new Point(clipBounds.x + clipBounds.width - 1, clipBounds.y + clipBounds.height - 1), effectiveZoom);
            int rightTile = bottomRightTileCoords.x >> 7;
            int bottomTile = bottomRightTileCoords.y >> 7;
            int middleTileX = (leftTile + rightTile) / 2;
            int middleTileY = (topTile + bottomTile) / 2;
            int radius = Math.max(Math.max(middleTileX - leftTile, rightTile - middleTileX), Math.max(middleTileY - topTile, bottomTile - middleTileY));
            this.paintTile(g2, gc, tileProvider, middleTileX, middleTileY, effectiveZoom);
            for (int r = 1; r <= radius; ++r) {
                for (int i = 0; i < r * 2; ++i) {
                    int tileX = middleTileX + i - r;
                    int tileY = middleTileY - r;
                    if (tileX >= leftTile && tileX <= rightTile && tileY >= topTile && tileY <= bottomTile) {
                        this.paintTile(g2, gc, tileProvider, tileX, tileY, effectiveZoom);
                    }
                    tileX = middleTileX + r;
                    tileY = middleTileY + i - r;
                    if (tileX >= leftTile && tileX <= rightTile && tileY >= topTile && tileY <= bottomTile) {
                        this.paintTile(g2, gc, tileProvider, tileX, tileY, effectiveZoom);
                    }
                    tileX = middleTileX + r - i;
                    tileY = middleTileY + r;
                    if (tileX >= leftTile && tileX <= rightTile && tileY >= topTile && tileY <= bottomTile) {
                        this.paintTile(g2, gc, tileProvider, tileX, tileY, effectiveZoom);
                    }
                    tileX = middleTileX - r;
                    tileY = middleTileY - i + r;
                    if (tileX < leftTile || tileX > rightTile || tileY < topTile || tileY > bottomTile) continue;
                    this.paintTile(g2, gc, tileProvider, tileX, tileY, effectiveZoom);
                }
            }
        }
        this.paintGridIfApplicable(g2);
        this.paintMarkerIfApplicable(g2);
        int myWidth = this.getWidth();
        int myHeight = this.getHeight();
        if (this.paintCentre) {
            int middleX = myWidth / 2;
            int middleY = myHeight / 2;
            g2.setColor(Color.BLACK);
            g2.drawLine(middleX - 4, middleY + 1, middleX + 6, middleY + 1);
            g2.drawLine(middleX + 1, middleY - 4, middleX + 1, middleY + 6);
            g2.setColor(Color.WHITE);
            g2.drawLine(middleX - 5, middleY, middleX + 5, middleY);
            g2.drawLine(middleX, middleY - 5, middleX, middleY + 5);
        }
        this.paintOverlays(g2);
        Rectangle viewBounds = new Rectangle(0, 0, myWidth, myHeight);
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            Iterator i = this.queue.iterator();
            while (i.hasNext()) {
                TileRenderJob job = (TileRenderJob)i.next();
                if (this.getTileBounds(((TileRenderJob)job).coords.x, ((TileRenderJob)job).coords.y, job.effectiveZoom).intersects(viewBounds)) continue;
                i.remove();
                this.tileCaches.get(job.tileProvider).remove(job.coords);
            }
        }
    }

    private void paintBackground(Graphics2D g2, Rectangle clipBounds) {
        if (this.backgroundImage != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            switch (this.backgroundImageMode) {
                case CENTRE: {
                    g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                    int imageWidth = this.backgroundImage.getWidth();
                    int imageHeight = this.backgroundImage.getHeight();
                    int imageX = (width - imageWidth) / 2;
                    int imageY = (height - imageHeight) / 2;
                    if (!clipBounds.intersects(imageX, imageY, imageWidth, imageHeight)) break;
                    g2.drawImage((Image)this.backgroundImage, imageX, imageY, null);
                    break;
                }
                case CENTRE_REPEAT: {
                    if (this.backgroundImage.getTransparency() != 1) {
                        g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                    }
                    this.repeatImage(g2, clipBounds, this.backgroundImage, (width - this.backgroundImage.getWidth()) / 2, (height - this.backgroundImage.getHeight()) / 2, this.backgroundImage.getWidth(), this.backgroundImage.getHeight());
                    break;
                }
                case FIT: 
                case FIT_REPEAT: {
                    int imageWidth = this.backgroundImage.getWidth();
                    int imageHeight = this.backgroundImage.getHeight();
                    float myRatio = (float)width / (float)height;
                    float imageRatio = (float)imageWidth / (float)imageHeight;
                    if (imageRatio > myRatio) {
                        imageWidth = width;
                        imageHeight = (int)((float)imageWidth / imageRatio);
                    } else {
                        imageHeight = height;
                        imageWidth = (int)((float)imageHeight * imageRatio);
                    }
                    int imageX = (width - imageWidth) / 2;
                    int imageY = (height - imageHeight) / 2;
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    if (this.backgroundImageMode == BackgroundImageMode.FIT) {
                        g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                        if (!clipBounds.intersects(imageX, imageY, imageWidth, imageHeight)) break;
                        g2.drawImage(this.backgroundImage, imageX, imageY, imageWidth, imageHeight, null);
                        break;
                    }
                    if (this.backgroundImage.getTransparency() != 1) {
                        g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                    }
                    this.repeatImage(g2, clipBounds, this.backgroundImage, imageX, imageY, imageWidth, imageHeight);
                    break;
                }
                case REPEAT: {
                    if (this.backgroundImage.getTransparency() != 1) {
                        g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                    }
                    this.repeatImage(g2, clipBounds, this.backgroundImage, 0, 0, this.backgroundImage.getWidth(), this.backgroundImage.getHeight());
                    break;
                }
                case STRETCH: {
                    if (this.backgroundImage.getTransparency() != 1) {
                        g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                    }
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2.drawImage(this.backgroundImage, 0, 0, width, height, null);
                }
            }
        } else {
            g2.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
    }

    private void repeatImage(Graphics2D g2, Rectangle clipBounds, BufferedImage image, int x, int y, int width, int height) {
        while (y > 0) {
            y -= height;
        }
        while (true) {
            if (x > 0) {
                x -= width;
                continue;
            }
            do {
                if (!clipBounds.intersects(x, y, width, height)) continue;
                g2.drawImage(image, x, y, width, height, null);
            } while ((x += width) < this.getWidth());
            if ((y += height) >= this.getHeight()) break;
        }
    }

    private void paintOverlays(Graphics2D g2) {
        this.overlays.values().forEach(overlay -> {
            int x = overlay.x >= 0 ? overlay.x : this.getWidth() + overlay.x;
            Point coords = SwingUtilities.convertPoint(overlay.componentToTrack, 0, 0, this);
            g2.drawImage((Image)overlay.image, x, coords.y, null);
        });
    }

    private void paintTile(Graphics2D g2, GraphicsConfiguration gc, TileProvider tileProvider, int x, int y, int effectiveZoom) {
        Rectangle tileBounds = this.getTileBounds(x, y, effectiveZoom);
        Image tile = this.getTile(tileProvider, x, y, effectiveZoom, gc);
        if (tile != null) {
            if (this.zoom + this.tileProviderZoom.getOrDefault(tileProvider, 0) > 0) {
                g2.drawImage(tile, tileBounds.x, tileBounds.y, tileBounds.width, tileBounds.height, this);
            } else {
                g2.drawImage(tile, tileBounds.x, tileBounds.y, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getTile(TileProvider tileProvider, int x, int y, int effectiveZoom, GraphicsConfiguration gc) {
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            Point coords = new Point(x, y);
            Map<Point, Reference<? extends Image>> tileCache = this.tileCaches.get(tileProvider);
            Map<Point, Reference<? extends Image>> dirtyTileCache = this.dirtyTileCaches.get(tileProvider);
            if (tileCache == null || dirtyTileCache == null) {
                logger.warn("tileCache or dirtyTileCache null! Proceeding without a tile...");
                return null;
            }
            Reference<? extends Image> ref = tileCache.get(coords);
            if (ref == RENDERING) {
                return this.getDirtyTile(coords, dirtyTileCache, gc);
            }
            if (ref != null) {
                Image tile = ref.get();
                if (tile == null) {
                    tileCache.remove(coords);
                    this.scheduleTile(tileCache, coords, tileProvider, dirtyTileCache, effectiveZoom, null);
                    return this.getDirtyTile(coords, dirtyTileCache, gc);
                }
                if (tile == NO_TILE) {
                    return null;
                }
                if (tile instanceof VolatileImage) {
                    switch (((VolatileImage)tile).validate(gc)) {
                        case 0: {
                            return tile;
                        }
                        case 1: {
                            this.scheduleTile(tileCache, coords, tileProvider, dirtyTileCache, effectiveZoom, tile);
                            return tile;
                        }
                        case 2: {
                            tileCache.remove(coords);
                            this.scheduleTile(tileCache, coords, tileProvider, dirtyTileCache, effectiveZoom, null);
                            return null;
                        }
                    }
                    throw new InternalError("Unknown validation result");
                }
                return tile;
            }
            this.scheduleTile(tileCache, coords, tileProvider, dirtyTileCache, effectiveZoom, null);
            return this.getDirtyTile(coords, dirtyTileCache, gc);
        }
    }

    private Image getDirtyTile(Point coords, Map<Point, Reference<? extends Image>> dirtyTileCache, GraphicsConfiguration gc) {
        Reference<? extends Image> dirtyRef = dirtyTileCache.get(coords);
        if (dirtyRef != null) {
            Image dirtyTile = dirtyRef.get();
            if (dirtyTile == null) {
                dirtyTileCache.remove(coords);
                return null;
            }
            if (dirtyTile == NO_TILE) {
                return null;
            }
            if (dirtyTile instanceof VolatileImage) {
                switch (((VolatileImage)dirtyTile).validate(gc)) {
                    case 0: {
                        return dirtyTile;
                    }
                    case 1: {
                        return dirtyTile;
                    }
                    case 2: {
                        dirtyTileCache.remove(coords);
                        return null;
                    }
                }
                throw new InternalError("Unknown validation result");
            }
            return dirtyTile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTile(Map<Point, Reference<? extends Image>> tileCache, Point coords, TileProvider tileProvider, Map<Point, Reference<? extends Image>> dirtyTileCache, int effectiveZoom, Image image) {
        Object object = this.TILE_CACHE_LOCK;
        synchronized (object) {
            if (tileProvider.isTilePresent(coords.x, coords.y)) {
                tileCache.put(coords, RENDERING);
                this.tileRenderers.execute(new TileRenderJob(tileCache, dirtyTileCache, coords, tileProvider, effectiveZoom, image));
            } else {
                tileCache.put(coords, new SoftReference<VolatileImage>(NO_TILE));
                dirtyTileCache.remove(coords);
                try {
                    this.repaint(this.getTileBounds(coords.x, coords.y, effectiveZoom));
                }
                catch (UnknownTileProviderException unknownTileProviderException) {
                    // empty catch block
                }
            }
        }
    }

    private void fireViewChangedEvent() {
        if (this.viewListener != null) {
            this.viewListener.viewChanged(this);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.xOffset = this.getWidth() / 2;
        this.yOffset = this.getHeight() / 2;
        this.fireViewChangedEvent();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void tileChanged(TileProvider source, int x, int y) {
        if (!this.inhibitUpdates) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.refresh(source, x, y);
            } else {
                SwingUtilities.invokeLater(() -> this.refresh(source, x, y));
            }
        }
    }

    @Override
    public void tilesChanged(TileProvider source, Set<Point> tiles) {
        if (!this.inhibitUpdates) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.refresh(source, tiles);
            } else {
                SwingUtilities.invokeLater(() -> this.refresh(source, tiles));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.leftClickDrags && e.getButton() == 1) {
            return;
        }
        this.previousX = e.getX();
        this.previousY = e.getY();
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.dragging = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.leftClickDrags && e.getButton() == 1) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.dragging = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        int dx = e.getX() - this.previousX;
        int dy = e.getY() - this.previousY;
        this.viewX -= dx;
        this.viewY -= dy;
        this.previousX = e.getX();
        this.previousY = e.getY();
        this.fireViewChangedEvent();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        if ((event.getChangeFlags() & 2L) != 0L) {
            if (this.isDisplayable()) {
                if (!this.tileProviders.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Starting " + this.threads + " tile rendering threads");
                    }
                    this.queue = new PriorityBlockingQueue<Runnable>();
                    this.tileRenderers = new ThreadPoolExecutor(this.threads, this.threads, 0L, TimeUnit.MILLISECONDS, this.queue);
                }
            } else if (this.tileRenderers != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Shutting down " + this.threads + " tile rendering threads");
                }
                this.queue.clear();
                this.tileRenderers.shutdownNow();
                this.queue = null;
                this.tileRenderers = null;
            }
        }
    }

    public static enum BackgroundImageMode {
        CENTRE,
        STRETCH,
        FIT,
        REPEAT,
        CENTRE_REPEAT,
        FIT_REPEAT;

    }

    class Overlay {
        final String key;
        final int x;
        final Component componentToTrack;
        final BufferedImage image;

        Overlay(Component componentToTrack, String key, int x, BufferedImage image) {
            this.componentToTrack = componentToTrack;
            this.key = key;
            this.x = x;
            this.image = image;
        }
    }

    public static interface ViewListener {
        public void viewChanged(TiledImageViewer var1);
    }

    class TileRenderJob
    implements Runnable,
    Comparable<TileRenderJob> {
        private final long seq;
        private final Map<Point, Reference<? extends Image>> tileCache;
        private final Map<Point, Reference<? extends Image>> dirtyTileCache;
        private final Point coords;
        private final TileProvider tileProvider;
        private final int effectiveZoom;
        private final int priority;
        private final Image image;

        TileRenderJob(Map<Point, Reference<? extends Image>> tileCache, Map<Point, Reference<? extends Image>> dirtyTileCache, Point coords, TileProvider tileProvider, int effectiveZoom, Image image) {
            this.tileCache = tileCache;
            this.dirtyTileCache = dirtyTileCache;
            this.coords = coords;
            this.tileProvider = tileProvider;
            this.effectiveZoom = effectiveZoom;
            this.image = image;
            this.seq = jobSeq.getAndIncrement();
            this.priority = tileProvider.getTilePriority(coords.x, coords.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            VolatileImage tile;
            if (logger.isTraceEnabled()) {
                logger.trace("Rendering tile " + this.coords.x + "," + this.coords.y);
            }
            int tileSize = this.tileProvider.getTileSize();
            if (this.image instanceof VolatileImage) {
                tile = (VolatileImage)this.image;
            } else {
                GraphicsConfiguration gc = TiledImageViewer.this.getGraphicsConfiguration();
                if (gc != null) {
                    tile = gc.createCompatibleVolatileImage(tileSize, tileSize, 3);
                    tile.validate(gc);
                } else {
                    logger.debug("Not rendering tile " + this.coords.x + "," + this.coords.y + " because there is no GraphicsConfiguration");
                    return;
                }
            }
            if (this.tileProvider.paintTile(tile, this.coords.x, this.coords.y, 0, 0)) {
                object = TiledImageViewer.this.TILE_CACHE_LOCK;
                synchronized (object) {
                    this.tileCache.put(this.coords, new SoftReference<VolatileImage>(tile));
                    if (this.dirtyTileCache.containsKey(this.coords)) {
                        this.dirtyTileCache.remove(this.coords);
                    }
                }
            }
            object = TiledImageViewer.this.TILE_CACHE_LOCK;
            synchronized (object) {
                this.tileCache.put(this.coords, new SoftReference<VolatileImage>(NO_TILE));
                if (this.dirtyTileCache.containsKey(this.coords)) {
                    this.dirtyTileCache.remove(this.coords);
                }
            }
            try {
                TiledImageViewer.this.repaint(TiledImageViewer.this.getTileBounds(this.coords.x, this.coords.y, this.effectiveZoom));
            }
            catch (UnknownTileProviderException unknownTileProviderException) {
                // empty catch block
            }
        }

        @Override
        public int compareTo(TileRenderJob o) {
            if (this.priority != o.priority) {
                return o.priority - this.priority;
            }
            return this.seq > o.seq ? 1 : -1;
        }
    }
}

