/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.pepsoft.util.IconUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.SystemUtils;
import org.pepsoft.util.swing.ManagesScale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIUtils {
    public static final float SYSTEM_UI_SCALE_FLOAT = GraphicsEnvironment.isHeadless() ? 1.0f : (SystemUtils.isWindows() ? MathUtils.clamp((float)1.0f, (float)((float)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0f), (float)2.0f) : 1.0f);
    public static final int SYSTEM_UI_SCALE = Math.round(SYSTEM_UI_SCALE_FLOAT);
    private static final Logger logger = LoggerFactory.getLogger(GUIUtils.class);
    private static float UI_SCALE_FLOAT;
    private static int UI_SCALE;

    public static BufferedImage scaleToUI(Image image) {
        return GUIUtils.scaleToUI(image, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage scaleToUI(Image image, boolean smooth) {
        BufferedImage scaledImage;
        if ((UI_SCALE_FLOAT == 1.0f || !smooth && UI_SCALE == 1) && image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (image instanceof BufferedImage) {
            AffineTransformOp op = smooth ? new AffineTransformOp(AffineTransform.getScaleInstance(GUIUtils.getUIScale(), GUIUtils.getUIScale()), 3) : new AffineTransformOp(AffineTransform.getScaleInstance(GUIUtils.getUIScaleInt(), GUIUtils.getUIScaleInt()), 1);
            return op.filter((BufferedImage)image, null);
        }
        if (smooth) {
            scaledImage = new BufferedImage(Math.round((float)image.getWidth(null) * GUIUtils.getUIScale()), Math.round((float)image.getHeight(null) * GUIUtils.getUIScale()), 2);
            Graphics2D g2 = scaledImage.createGraphics();
            try {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(image, AffineTransform.getScaleInstance(GUIUtils.getUIScale(), GUIUtils.getUIScale()), null);
            }
            finally {
                g2.dispose();
            }
        }
        scaledImage = new BufferedImage(image.getWidth(null) * GUIUtils.getUIScaleInt(), image.getHeight(null) * GUIUtils.getUIScaleInt(), 2);
        Graphics2D g2 = scaledImage.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g2.drawImage(image, AffineTransform.getScaleInstance(GUIUtils.getUIScaleInt(), GUIUtils.getUIScaleInt()), null);
        }
        finally {
            g2.dispose();
        }
        return scaledImage;
    }

    public static void scaleToUI(Container container) {
        if (UI_SCALE_FLOAT == 1.0f) {
            return;
        }
        for (Component component : container.getComponents()) {
            ImageIcon icon;
            AbstractButton button;
            if (component instanceof ManagesScale) continue;
            if (component instanceof JTable) {
                JTable table = (JTable)component;
                table.setRowHeight(Math.round((float)table.getRowHeight() * UI_SCALE_FLOAT));
                table.setRowMargin(Math.round((float)table.getRowMargin() * UI_SCALE_FLOAT));
                table.revalidate();
            } else if (component instanceof JTextArea) {
                component.setFont(UIManager.getFont("TextField.font"));
                component.revalidate();
            } else if (component instanceof AbstractButton && (button = (AbstractButton)component).getIcon() instanceof ImageIcon && (icon = (ImageIcon)button.getIcon()).getIconWidth() == icon.getIconHeight()) {
                button.setIcon(IconUtils.scaleIcon(icon, icon.getIconWidth()));
                button.revalidate();
            }
            if (!(component instanceof Container)) continue;
            GUIUtils.scaleToUI((Container)component);
        }
    }

    public static void scaleWindow(Window window) {
        GraphicsConfiguration gc = window.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        window.setSize(Math.min(Math.round((float)window.getWidth() * UI_SCALE_FLOAT), screenBounds.width - insets.left - insets.right), Math.min(Math.round((float)window.getHeight() * UI_SCALE_FLOAT), screenBounds.height - insets.top - insets.bottom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scaleLookAndFeel(float scale) {
        if (scale == 1.0f) {
            return;
        }
        HashSet<Object> unknownValueTypesEncountered = new HashSet<Object>();
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Object key = entry.getKey();
            Object value = UIManager.get(key);
            try {
                Icon icon;
                Insets oldResource;
                if (value instanceof FontUIResource) {
                    FontUIResource previousResource = (FontUIResource)value;
                    UIManager.put(key, new FontUIResource(previousResource.getFamily(), previousResource.getStyle(), Math.round((float)previousResource.getSize() * scale)));
                    logger.trace("Scaled FontUIResource {}", key);
                    continue;
                }
                if (value instanceof InsetsUIResource) {
                    oldResource = (InsetsUIResource)value;
                    UIManager.put(key, new InsetsUIResource(Math.round((float)oldResource.top * scale), Math.round((float)oldResource.left * scale), Math.round((float)oldResource.bottom * scale), Math.round((float)oldResource.right * scale)));
                    logger.trace("Scaled InsetsUIResource {}", key);
                    continue;
                }
                if (value instanceof Insets) {
                    oldResource = (Insets)value;
                    UIManager.put(key, new Insets(Math.round((float)oldResource.top * scale), Math.round((float)oldResource.left * scale), Math.round((float)oldResource.bottom * scale), Math.round((float)oldResource.right * scale)));
                    logger.trace("Scaled Insets {}", key);
                    continue;
                }
                if (value instanceof Integer && key instanceof String) {
                    String lowerCaseKey = ((String)key).toLowerCase();
                    if (lowerCaseKey.contains("margin") || lowerCaseKey.contains("thickness") || lowerCaseKey.contains("gap") || lowerCaseKey.contains("width") || lowerCaseKey.contains("height") || lowerCaseKey.contains("spacing") || lowerCaseKey.contains("size") || lowerCaseKey.contains("length") || lowerCaseKey.contains("offset") || lowerCaseKey.contains("shift") || lowerCaseKey.contains("indent") || lowerCaseKey.contains("padding")) {
                        UIManager.put(key, Math.round((float)((Integer)value).intValue() * scale));
                        logger.trace("Scaled integer {}", key);
                        continue;
                    }
                    unknownValueTypesEncountered.add("Integer for key " + key);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Did NOT scale {}: {}} ({}})", new Object[]{key, value, value.getClass().getSimpleName()});
                    continue;
                }
                if (value instanceof ImageIcon) {
                    icon = (ImageIcon)value;
                    UIManager.put(key, new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(Math.round((float)((ImageIcon)icon).getIconWidth() * scale), -1, 4)));
                    logger.trace("Scaled ImageIcon {}", key);
                    continue;
                }
                if (value instanceof Icon) {
                    icon = (Icon)value;
                    BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                    Graphics2D g2 = image.createGraphics();
                    try {
                        try {
                            icon.paintIcon(null, g2, 0, 0);
                        }
                        finally {
                            g2.dispose();
                        }
                        UIManager.put(key, new ImageIcon(image.getScaledInstance(Math.round((float)icon.getIconWidth() * scale), -1, 4)));
                        logger.trace("Scaled Icon {}", key);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        logger.debug("Did NOT scale Icon {} due to {}", key, (Object)e.getClass().getSimpleName());
                    }
                    continue;
                }
                if (value instanceof Color || value instanceof Boolean || value == null) continue;
                unknownValueTypesEncountered.add(value.getClass().getSimpleName());
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Did NOT scale {}: {}} ({}})", new Object[]{key, value, value.getClass().getSimpleName()});
            }
            catch (Throwable t) {
                logger.error("Did NOT scale {}: {}} ({}}) due to {} (message: \"{}\")", new Object[]{key, value, value.getClass().getSimpleName(), t.getClass().getSimpleName(), t.getMessage(), t});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Did NOT scale value types: {}", unknownValueTypesEncountered);
        }
    }

    public static void setUIScale(float uiScale) {
        UI_SCALE_FLOAT = uiScale;
        UI_SCALE = Math.round(uiScale);
    }

    public static float getUIScale() {
        return UI_SCALE_FLOAT;
    }

    public static int getUIScaleInt() {
        return UI_SCALE;
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("org.pepsoft.util.GUIUtils.disableScaling"))) {
            logger.info("Not scaling GUI");
            UI_SCALE_FLOAT = 1.0f;
        } else {
            float manualUIScale = Preferences.userNodeForPackage(GUIUtils.class).getFloat(("true".equalsIgnoreCase(System.getProperty("org.pepsoft.snapshotVersion")) ? "snapshot." : "") + "manualUIScale", -1.0f);
            UI_SCALE_FLOAT = manualUIScale > 0.0f ? manualUIScale : SYSTEM_UI_SCALE_FLOAT;
        }
        UI_SCALE = Math.max(Math.round(UI_SCALE_FLOAT), 1);
    }
}

