/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.pepsoft.util.swing.TiledImageViewer;

public class TiledImageViewerContainer
extends JPanel
implements TiledImageViewer.ViewListener,
AdjustmentListener {
    private final JPanel viewContainer = new JPanel(new BorderLayout());
    private final JScrollBar horizontalScrollbar = new JScrollBar(0);
    private final JScrollBar verticalScrollbar = new JScrollBar();
    private TiledImageViewer view;
    private int previousHorizontalValue;
    private int previousVerticalValue;
    private boolean scrollingEnabled = true;
    private boolean programmaticChange;
    private boolean inhibitUpdates;

    public TiledImageViewerContainer() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this.viewContainer, constraints);
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        this.add((Component)this.verticalScrollbar, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        this.add((Component)this.horizontalScrollbar, constraints);
        this.horizontalScrollbar.addAdjustmentListener(this);
        this.verticalScrollbar.addAdjustmentListener(this);
    }

    public TiledImageViewerContainer(Component view) {
        this();
        this.setView(view);
    }

    public TiledImageViewer getView() {
        return this.view;
    }

    public void setView(Component view) {
        if (this.view != null) {
            this.view.setViewListener(null);
            this.viewContainer.removeAll();
        }
        if (view != null) {
            TiledImageViewer tiledImageViewer = this.findTiledImageViewer(view);
            if (tiledImageViewer == null) {
                throw new IllegalArgumentException("Specified component does not contain a TiledImageViewer");
            }
            this.view = tiledImageViewer;
            this.view.setViewListener(this);
            this.viewContainer.add(view, "Center");
        } else {
            this.view = null;
        }
    }

    private TiledImageViewer findTiledImageViewer(Component component) {
        if (component instanceof TiledImageViewer) {
            return (TiledImageViewer)component;
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                TiledImageViewer tiledImageViewer = this.findTiledImageViewer(child);
                if (tiledImageViewer == null) continue;
                return tiledImageViewer;
            }
        }
        return null;
    }

    public void setInhibitUpdates(boolean inhibitUpdates) {
        if (inhibitUpdates != this.inhibitUpdates) {
            this.inhibitUpdates = inhibitUpdates;
            if (!inhibitUpdates) {
                this.programmaticChange = true;
                try {
                    this.updateScrollBars();
                }
                finally {
                    this.programmaticChange = false;
                }
            }
        }
    }

    @Override
    public void viewChanged(TiledImageViewer source) {
        if (!this.programmaticChange && !this.inhibitUpdates) {
            this.programmaticChange = true;
            try {
                this.updateScrollBars();
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.programmaticChange) {
            return;
        }
        this.programmaticChange = true;
        try {
            int dy;
            if (e.getSource() == this.horizontalScrollbar) {
                int dx = e.getValue() - this.previousHorizontalValue;
                if (dx != 0) {
                    this.previousHorizontalValue = e.getValue();
                    this.view.moveBy(dx, 0);
                    if (!e.getValueIsAdjusting()) {
                        this.updateScrollBars();
                    }
                }
            } else if (e.getSource() == this.verticalScrollbar && (dy = e.getValue() - this.previousVerticalValue) != 0) {
                this.previousVerticalValue = e.getValue();
                this.view.moveBy(0, dy);
                if (!e.getValueIsAdjusting()) {
                    this.updateScrollBars();
                }
            }
        }
        finally {
            this.programmaticChange = false;
        }
    }

    private void updateScrollBars() {
        Rectangle viewExtent = this.view.getExtent();
        if (viewExtent == null) {
            if (this.scrollingEnabled) {
                this.horizontalScrollbar.setEnabled(false);
                this.verticalScrollbar.setEnabled(false);
                this.scrollingEnabled = false;
            }
        } else {
            if (!this.scrollingEnabled) {
                this.horizontalScrollbar.setEnabled(true);
                this.verticalScrollbar.setEnabled(true);
                this.scrollingEnabled = true;
            }
            int viewWidth = this.view.getWidth();
            int viewHeight = this.view.getHeight();
            if (viewExtent.width < viewWidth) {
                viewExtent.x -= viewWidth - viewExtent.width;
                viewExtent.width += (viewWidth - viewExtent.width) * 2;
            }
            if (viewExtent.height < viewHeight) {
                viewExtent.y -= viewHeight - viewExtent.height;
                viewExtent.height += (viewHeight - viewExtent.height) * 2;
            }
            Rectangle viewBounds = new Rectangle(0, 0, viewWidth, viewHeight);
            Rectangle combinedArea = viewExtent.union(viewBounds);
            this.horizontalScrollbar.setMinimum(combinedArea.x);
            this.horizontalScrollbar.setMaximum(combinedArea.x + combinedArea.width);
            this.horizontalScrollbar.setVisibleAmount(viewWidth);
            this.horizontalScrollbar.setValue(0);
            this.horizontalScrollbar.setBlockIncrement(viewWidth * 9 / 10);
            this.previousHorizontalValue = 0;
            this.verticalScrollbar.setMinimum(combinedArea.y);
            this.verticalScrollbar.setMaximum(combinedArea.y + combinedArea.height);
            this.verticalScrollbar.setVisibleAmount(viewHeight);
            this.verticalScrollbar.setValue(0);
            this.verticalScrollbar.setBlockIncrement(viewHeight * 9 / 10);
            this.previousVerticalValue = 0;
        }
    }
}

