/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class BitField {
    private int cachedX;
    private int cachedY;
    private BitSet cachedBits;
    private final Map<Point, BitSet> booleans = new HashMap<Point, BitSet>();

    public void set(int x, int y) {
        if (x != this.cachedX || y != this.cachedY) {
            this.cachedBits = this.booleans.computeIfAbsent(new Point(x >> 7, y >> 7), c -> new BitSet(16384));
            this.cachedX = x;
            this.cachedY = y;
        }
        if (this.cachedBits == null) {
            this.cachedBits = new BitSet(16384);
            this.booleans.put(new Point(x >> 7, y >> 7), this.cachedBits);
        }
        this.cachedBits.set((x & 0x7F) << 7 | y & 0x7F);
    }

    public void reset(int x, int y) {
        if (x != this.cachedX || y != this.cachedY) {
            this.cachedBits = this.booleans.get(new Point(x >> 7, y >> 7));
            this.cachedX = x;
            this.cachedY = y;
        }
        if (this.cachedBits != null) {
            this.cachedBits.clear((x & 0x7F) << 7 | y & 0x7F);
        }
    }

    public boolean get(int x, int y) {
        if (x != this.cachedX || y != this.cachedY) {
            this.cachedBits = this.booleans.get(new Point(x >> 7, y >> 7));
            this.cachedX = x;
            this.cachedY = y;
        }
        if (this.cachedBits != null) {
            return this.cachedBits.get((x & 0x7F) << 7 | y & 0x7F);
        }
        return false;
    }

    public Rectangle getBoundingBox() {
        throw new UnsupportedOperationException();
    }

    public boolean visitSetBits(BitVisitor visitor) {
        for (Map.Entry<Point, BitSet> entry : this.booleans.entrySet()) {
            int xOffset = entry.getKey().x << 7;
            int yOffset = entry.getKey().y << 7;
            BitSet bits = entry.getValue();
            int i = bits.nextSetBit(0);
            while (i >= 0) {
                int x = (i & 0x3F80) >> 7;
                int y = i & 0x7F;
                if (!visitor.visitBit(xOffset | x, yOffset | y, true)) {
                    return false;
                }
                i = bits.nextSetBit(i + 1);
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface BitVisitor {
        public boolean visitBit(int var1, int var2, boolean var3);
    }
}

