/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;

public final class XDG {
    public static final String HOME;
    public static final String XDG_DATA_HOME;
    public static final String XDG_CONFIG_HOME;
    public static final String XDG_DATA_DIRS;
    public static final String XDG_CONFIG_DIRS;
    public static final String XDG_CACHE_HOME;
    public static final String XDG_RUNTIME_DIR;
    public static final File XDG_DATA_HOME_FILE;
    public static final File XDG_CONFIG_HOME_FILE;
    public static final File XDG_CACHE_HOME_FILE;
    public static final File XDG_RUNTIME_DIR_FILE;
    public static final String XDG_DESKTOP_DIR;
    public static final String XDG_DOCUMENTS_DIR;
    public static final String XDG_DOWNLOAD_DIR;
    public static final String XDG_MUSIC_DIR;
    public static final String XDG_PICTURES_DIR;
    public static final String XDG_PUBLICSHARE_DIR;
    public static final String XDG_TEMPLATES_DIR;
    public static final String XDG_VIDEOS_DIR;
    public static final File XDG_DESKTOP_DIR_FILE;
    public static final File XDG_DOCUMENTS_DIR_FILE;
    public static final File XDG_DOWNLOAD_DIR_FILE;
    public static final File XDG_MUSIC_DIR_FILE;
    public static final File XDG_PICTURES_DIR_FILE;
    public static final File XDG_PUBLICSHARE_DIR_FILE;
    public static final File XDG_TEMPLATES_DIR_FILE;
    public static final File XDG_VIDEOS_DIR_FILE;

    private XDG() {
    }

    public static void main(String[] args) {
        System.out.println("HOME: " + HOME);
        System.out.println("XDG_DATA_HOME: " + XDG_DATA_HOME);
        System.out.println("XDG_CONFIG_HOME: " + XDG_CONFIG_HOME);
        System.out.println("XDG_DATA_DIRS: " + XDG_DATA_DIRS);
        System.out.println("XDG_CONFIG_DIRS: " + XDG_CONFIG_DIRS);
        System.out.println("XDG_CACHE_HOME: " + XDG_CACHE_HOME);
        System.out.println("XDG_RUNTIME_DIR: " + XDG_RUNTIME_DIR);
        System.out.println("XDG_DATA_HOME_FILE: " + XDG_DATA_HOME_FILE);
        System.out.println("XDG_CONFIG_HOME_FILE: " + XDG_CONFIG_HOME_FILE);
        System.out.println("XDG_CACHE_HOME_FILE: " + XDG_CACHE_HOME_FILE);
        System.out.println("XDG_RUNTIME_DIR_FILE: " + XDG_RUNTIME_DIR_FILE);
        System.out.println("XDG_DESKTOP_DIR: " + XDG_DESKTOP_DIR);
        System.out.println("XDG_DOCUMENTS_DIR: " + XDG_DOCUMENTS_DIR);
        System.out.println("XDG_DOWNLOAD_DIR: " + XDG_DOWNLOAD_DIR);
        System.out.println("XDG_MUSIC_DIR: " + XDG_MUSIC_DIR);
        System.out.println("XDG_PICTURES_DIR: " + XDG_PICTURES_DIR);
        System.out.println("XDG_PUBLICSHARE_DIR: " + XDG_PUBLICSHARE_DIR);
        System.out.println("XDG_TEMPLATES_DIR: " + XDG_TEMPLATES_DIR);
        System.out.println("XDG_VIDEOS_DIR: " + XDG_VIDEOS_DIR);
        System.out.println("XDG_DESKTOP_DIR_FILE: " + XDG_DESKTOP_DIR_FILE);
        System.out.println("XDG_DOCUMENTS_DIR_FILE: " + XDG_DOCUMENTS_DIR_FILE);
        System.out.println("XDG_DOWNLOAD_DIR_FILE: " + XDG_DOWNLOAD_DIR_FILE);
        System.out.println("XDG_MUSIC_DIR_FILE: " + XDG_MUSIC_DIR_FILE);
        System.out.println("XDG_PICTURES_DIR_FILE: " + XDG_PICTURES_DIR_FILE);
        System.out.println("XDG_PUBLICSHARE_DIR_FILE: " + XDG_PUBLICSHARE_DIR_FILE);
        System.out.println("XDG_TEMPLATES_DIR_FILE: " + XDG_TEMPLATES_DIR_FILE);
        System.out.println("XDG_VIDEOS_DIR_FILE: " + XDG_VIDEOS_DIR_FILE);
    }

    private static void readShellVarScript(File script, Properties props) {
        try (BufferedReader in = new BufferedReader(new FileReader(script));){
            String line;
            while ((line = in.readLine()) != null) {
                String previousValue;
                int p = (line = line.trim()).indexOf(61);
                if (p < 0) continue;
                String key = line.substring(0, p);
                String value = line.substring(p + 1);
                if (value.length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                do {
                    previousValue = value;
                } while (!(value = XDG.expandVariables(value)).equals(previousValue));
                props.setProperty(key, value);
            }
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error reading " + script, e);
        }
    }

    private static String expandVariables(String value) {
        StringBuilder result = new StringBuilder(value.length());
        StringBuilder varName = new StringBuilder(100);
        boolean COPYING = true;
        int DOLLAR_ENCOUNTERED = 2;
        int READING_VAR_NAME = 3;
        int state = 1;
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (state) {
                case 1: {
                    if (c == '$') {
                        state = 2;
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                case 2: {
                    if (Character.isLetter(c) || c == '_') {
                        varName.setLength(0);
                        varName.append(c);
                        state = 3;
                        continue block5;
                    }
                    result.append('$');
                    result.append(c);
                    state = 1;
                    continue block5;
                }
                case 3: {
                    if (Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                        varName.append(c);
                        continue block5;
                    }
                    String varNameStr = varName.toString();
                    if (varNameStr.equals("HOME")) {
                        result.append(System.getProperty("user.home"));
                    } else if (System.getenv(varNameStr) != null) {
                        result.append(varNameStr);
                    }
                    result.append(c);
                    state = 1;
                }
            }
        }
        if (state == 2) {
            result.append('$');
        } else if (state == 3) {
            String varNameStr = varName.toString();
            if (varNameStr.equals("HOME")) {
                result.append(System.getProperty("user.home"));
            } else if (System.getenv(varNameStr) != null) {
                result.append(varNameStr);
            }
        }
        return result.toString();
    }

    static {
        String[] configDirs;
        HOME = System.getProperty("user.home");
        XDG_DATA_HOME = System.getenv("XDG_DATA_HOME") != null ? System.getenv("XDG_DATA_HOME") : HOME + File.separatorChar + ".local" + File.separatorChar + "share";
        XDG_CONFIG_HOME = System.getenv("XDG_CONFIG_HOME") != null ? System.getenv("XDG_CONFIG_HOME") : HOME + File.separatorChar + ".config";
        XDG_DATA_DIRS = System.getenv("XDG_DATA_DIRS") != null ? System.getenv("XDG_DATA_DIRS") : File.separatorChar + "usr" + File.separatorChar + "local" + File.separatorChar + "share" + File.pathSeparatorChar + File.separatorChar + "usr" + File.separatorChar + "share";
        XDG_CONFIG_DIRS = System.getenv("XDG_CONFIG_DIRS") != null ? System.getenv("XDG_CONFIG_DIRS") : File.separatorChar + "etc" + File.separatorChar + "xdg";
        XDG_CACHE_HOME = System.getenv("XDG_CACHE_HOME") != null ? System.getenv("XDG_CACHE_HOME") : HOME + File.separatorChar + ".cache";
        XDG_RUNTIME_DIR = System.getenv("XDG_RUNTIME_DIR");
        XDG_DATA_HOME_FILE = new File(XDG_DATA_HOME).isDirectory() ? new File(XDG_DATA_HOME) : null;
        XDG_CONFIG_HOME_FILE = new File(XDG_CONFIG_HOME).isDirectory() ? new File(XDG_CONFIG_HOME) : null;
        File file = XDG_CACHE_HOME_FILE = new File(XDG_CACHE_HOME).isDirectory() ? new File(XDG_CACHE_HOME) : null;
        XDG_RUNTIME_DIR_FILE = XDG_RUNTIME_DIR != null ? (new File(XDG_RUNTIME_DIR).isDirectory() ? new File(XDG_RUNTIME_DIR) : null) : null;
        Properties userDirs = new Properties();
        for (String configDir : configDirs = XDG_CONFIG_DIRS.split(File.pathSeparator)) {
            File userDirFile = new File(configDir, "user-dirs.default");
            if (!userDirFile.isFile()) continue;
            XDG.readShellVarScript(userDirFile, userDirs);
        }
        File userConfigFile = new File(XDG_CONFIG_HOME, "user-dirs.dirs");
        if (userConfigFile.isFile()) {
            XDG.readShellVarScript(userConfigFile, userDirs);
        }
        XDG_DESKTOP_DIR = userDirs.getProperty("XDG_DESKTOP_DIR");
        XDG_DOCUMENTS_DIR = userDirs.getProperty("XDG_DOCUMENTS_DIR");
        XDG_DOWNLOAD_DIR = userDirs.getProperty("XDG_DOWNLOAD_DIR");
        XDG_MUSIC_DIR = userDirs.getProperty("XDG_MUSIC_DIR");
        XDG_PICTURES_DIR = userDirs.getProperty("XDG_PICTURES_DIR");
        XDG_PUBLICSHARE_DIR = userDirs.getProperty("XDG_PUBLICSHARE_DIR");
        XDG_TEMPLATES_DIR = userDirs.getProperty("XDG_TEMPLATES_DIR");
        XDG_VIDEOS_DIR = userDirs.getProperty("XDG_VIDEOS_DIR");
        XDG_DESKTOP_DIR_FILE = XDG_DESKTOP_DIR != null && new File(XDG_DESKTOP_DIR).isDirectory() ? new File(XDG_DESKTOP_DIR) : null;
        XDG_DOCUMENTS_DIR_FILE = XDG_DOCUMENTS_DIR != null && new File(XDG_DOCUMENTS_DIR).isDirectory() ? new File(XDG_DOCUMENTS_DIR) : null;
        XDG_DOWNLOAD_DIR_FILE = XDG_DOWNLOAD_DIR != null && new File(XDG_DOWNLOAD_DIR).isDirectory() ? new File(XDG_DOWNLOAD_DIR) : null;
        XDG_MUSIC_DIR_FILE = XDG_MUSIC_DIR != null && new File(XDG_MUSIC_DIR).isDirectory() ? new File(XDG_MUSIC_DIR) : null;
        XDG_PICTURES_DIR_FILE = XDG_PICTURES_DIR != null && new File(XDG_PICTURES_DIR).isDirectory() ? new File(XDG_PICTURES_DIR) : null;
        XDG_PUBLICSHARE_DIR_FILE = XDG_PUBLICSHARE_DIR != null && new File(XDG_PUBLICSHARE_DIR).isDirectory() ? new File(XDG_PUBLICSHARE_DIR) : null;
        XDG_TEMPLATES_DIR_FILE = XDG_TEMPLATES_DIR != null && new File(XDG_TEMPLATES_DIR).isDirectory() ? new File(XDG_TEMPLATES_DIR) : null;
        XDG_VIDEOS_DIR_FILE = XDG_VIDEOS_DIR != null && new File(XDG_VIDEOS_DIR).isDirectory() ? new File(XDG_VIDEOS_DIR) : null;
    }
}

