/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.jobqueue;

import org.pepsoft.util.jobqueue.HashList;
import org.pepsoft.util.jobqueue.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueJobQueue<T extends Job> {
    private final HashList<T> queue = new HashList();
    private static final Logger logger = LoggerFactory.getLogger(UniqueJobQueue.class);

    public synchronized T takeJob() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait();
        }
        return (T)((Job)this.queue.remove(0));
    }

    public synchronized T pollJob() {
        if (!this.queue.isEmpty()) {
            Job job = (Job)this.queue.remove(0);
            this.notifyAll();
            return (T)job;
        }
        return null;
    }

    public synchronized boolean scheduleJobIfNotScheduled(T job) {
        if (!this.queue.contains(job)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Scheduling job " + job);
            }
            this.queue.add(job);
            this.notifyAll();
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("NOT scheduling job " + job + " due to duplicate on queue");
        }
        return false;
    }

    public synchronized boolean rescheduleJob(T job) {
        if (this.queue.contains(job)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling job " + job + ", replacing existing job");
            }
            this.queue.add(job);
            this.notifyAll();
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling job " + job);
        }
        this.queue.add(job);
        this.notifyAll();
        return false;
    }

    public synchronized boolean removeJob(T job) {
        if (this.queue.contains(job)) {
            this.queue.remove(job);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized void drain() throws InterruptedException {
        while (!this.queue.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void clear() {
        this.queue.clear();
        this.notifyAll();
    }
}

