/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.mdc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.pepsoft.util.mdc.MDCContextProvider;
import org.pepsoft.util.mdc.MDCWrappingException;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;
import org.slf4j.MDC;

public final class MDCUtils {
    public static Map<String, String> gatherMdcContext(Throwable exception) {
        HashMap mdcContext = new HashMap();
        do {
            Optional.of(exception).filter(e -> e instanceof MDCContextProvider).map(e -> ((MDCContextProvider)((Object)e)).getMdcContext()).ifPresent(context -> context.forEach((key, value) -> mdcContext.computeIfAbsent(key, k -> new HashSet()).add(value)));
        } while ((exception = exception.getCause()) != null);
        return mdcContext.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.join((CharSequence)",", (Iterable)entry.getValue())));
    }

    public static <T> T doWithMdcContext(Callable<T> task, Object ... context) {
        HashSet<Object> keys = new HashSet<Object>();
        for (int i = 0; i < context.length; i += 2) {
            String key = (String)context[i];
            String value = String.valueOf(context[i + 1]);
            keys.add(key);
            MDC.put((String)key, (String)value);
        }
        try {
            T i = task.call();
            return i;
        }
        catch (Exception e) {
            boolean found = false;
            Throwable exception = e;
            do {
                if (!(exception instanceof MDCContextProvider)) continue;
                found = true;
                break;
            } while ((exception = exception.getCause()) != null);
            if (found) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            throw new MDCWrappingRuntimeException(e);
        }
        finally {
            for (String string : keys) {
                MDC.remove((String)string);
            }
        }
    }

    public static Throwable decorateWithMdcContext(Throwable exception) {
        Throwable cause = exception;
        do {
            if (!(cause instanceof MDCContextProvider)) continue;
            return exception;
        } while ((cause = cause.getCause()) != null);
        if (exception instanceof RuntimeException) {
            return new MDCWrappingRuntimeException(exception);
        }
        return new MDCWrappingException(exception);
    }
}

